<?php


namespace Gek\AaApi\NewsML\NewsComponent;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * @XmlType(name = "", propOrder = { "usageType", "geography", "rightsHolder", "limitations", "startDate",
 * "endDate" })
 * Class UsageRights
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class UsageRights
{
    #region fields

    /**
     * XmlElement(name = "UsageType")
     *
     * @var UsageType|null
     */
    protected ?UsageType $usageType = null;

    /**
     * XmlElement(name = "Geography")
     *
     * @var Geography|null
     */
    protected ?Geography $geography = null;

    /**
     * XmlElement(name = "RightsHolder")
     *
     * @var RightsHolder|null
     */
    protected ?RightsHolder $rightsHolder = null;

    /**
     * XmlElement(name = "Limitations")
     *
     * @var Limitations|null
     */
    protected ?Limitations $limitations = null;

    /**
     * XmlElement(name = "StartDate")
     *
     * @var StartDate|null
     */
    protected ?StartDate $startDate = null;

    /**
     * XmlElement(name = "EndDate")
     *
     * @var EndDate|null
     */
    protected ?EndDate $endDate = null;

    /**
     * XmlAttribute(name = "AssignedBy")
     *
     * @var string|null
     */
    protected ?string $assignedBy = null;

    /**
     * XmlAttribute(name = "Importance")
     *
     * @var string|null
     */
    protected ?string $importance = null;

    /**
     * XmlAttribute(name = "Confidence")
     *
     * @var string|null
     */
    protected ?string $confidence = null;

    /**
     * XmlAttribute(name = "HowPresent")
     *
     * @var string|null
     */
    protected ?string $howPresent = null;

    /**
     * XmlAttribute(name = "DateAndTime")
     *
     * @var string|null
     */
    protected ?string $dateAndTime = null;

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     *
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return UsageType|null
     */
    public function getUsageType(): ?UsageType
    {
        return $this->usageType;
    }

    /**
     * @param UsageType|null $usageType
     * @return UsageRights
     */
    public function setUsageType(?UsageType $usageType): UsageRights
    {
        $this->usageType = $usageType;
        return $this;
    }

    /**
     * @return Geography|null
     */
    public function getGeography(): ?Geography
    {
        return $this->geography;
    }

    /**
     * @param Geography|null $geography
     * @return UsageRights
     */
    public function setGeography(?Geography $geography): UsageRights
    {
        $this->geography = $geography;
        return $this;
    }

    /**
     * @return RightsHolder|null
     */
    public function getRightsHolder(): ?RightsHolder
    {
        return $this->rightsHolder;
    }

    /**
     * @param RightsHolder|null $rightsHolder
     * @return UsageRights
     */
    public function setRightsHolder(?RightsHolder $rightsHolder): UsageRights
    {
        $this->rightsHolder = $rightsHolder;
        return $this;
    }

    /**
     * @return Limitations|null
     */
    public function getLimitations(): ?Limitations
    {
        return $this->limitations;
    }

    /**
     * @param Limitations|null $limitations
     * @return UsageRights
     */
    public function setLimitations(?Limitations $limitations): UsageRights
    {
        $this->limitations = $limitations;
        return $this;
    }

    /**
     * @return StartDate|null
     */
    public function getStartDate(): ?StartDate
    {
        return $this->startDate;
    }

    /**
     * @param StartDate|null $startDate
     * @return UsageRights
     */
    public function setStartDate(?StartDate $startDate): UsageRights
    {
        $this->startDate = $startDate;
        return $this;
    }

    /**
     * @return EndDate|null
     */
    public function getEndDate(): ?EndDate
    {
        return $this->endDate;
    }

    /**
     * @param EndDate|null $endDate
     * @return UsageRights
     */
    public function setEndDate(?EndDate $endDate): UsageRights
    {
        $this->endDate = $endDate;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAssignedBy(): ?string
    {
        return $this->assignedBy;
    }

    /**
     * @param string|null $assignedBy
     * @return UsageRights
     */
    public function setAssignedBy(?string $assignedBy): UsageRights
    {
        $this->assignedBy = $assignedBy;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getImportance(): ?string
    {
        return $this->importance;
    }

    /**
     * @param string|null $importance
     * @return UsageRights
     */
    public function setImportance(?string $importance): UsageRights
    {
        $this->importance = $importance;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getConfidence(): ?string
    {
        return $this->confidence;
    }

    /**
     * @param string|null $confidence
     * @return UsageRights
     */
    public function setConfidence(?string $confidence): UsageRights
    {
        $this->confidence = $confidence;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getHowPresent(): ?string
    {
        return $this->howPresent;
    }

    /**
     * @param string|null $howPresent
     * @return UsageRights
     */
    public function setHowPresent(?string $howPresent): UsageRights
    {
        $this->howPresent = $howPresent;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDateAndTime(): ?string
    {
        return $this->dateAndTime;
    }

    /**
     * @param string|null $dateAndTime
     * @return UsageRights
     */
    public function setDateAndTime(?string $dateAndTime): UsageRights
    {
        $this->dateAndTime = $dateAndTime;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return UsageRights
     */
    public function setDuid(?string $duid): UsageRights
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return UsageRights
     */
    public function setEuid(?string $euid): UsageRights
    {
        $this->euid = $euid;
        return $this;
    }



    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }

            $assignedByAttr = $node->attributes->getNamedItem('AssignedBy');
            if (!empty($assignedByAttr)) {
                $res->assignedBy = (string)$assignedByAttr->nodeValue;
            }

            $importanceAttr = $node->attributes->getNamedItem('Importance');
            if (!empty($importanceAttr)) {
                $res->importance = (string)$importanceAttr->nodeValue;
            }

            $confidenceAttr = $node->attributes->getNamedItem('Confidence');
            if (!empty($confidenceAttr)) {
                $res->confidence = (string)$confidenceAttr->nodeValue;
            }

            $howPresentAttr = $node->attributes->getNamedItem('HowPresent');
            if (!empty($howPresentAttr)) {
                $res->howPresent = (string)$howPresentAttr->nodeValue;
            }

            $dateAndTimeAttr = $node->attributes->getNamedItem('DateAndTime');
            if (!empty($dateAndTimeAttr)) {
                $res->dateAndTime = (string)$dateAndTimeAttr->nodeValue;
            }

        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'UsageType':
                    $res->usageType = UsageType::parse($curNode);
                    break;
                case 'Geography':
                    $res->geography = Geography::parse($curNode);
                    break;
                case 'RightsHolder':
                    $res->rightsHolder = RightsHolder::parse($curNode);
                    break;
                case 'Limitations':
                    $res->limitations = Limitations::parse($curNode);
                    break;
                case 'StartDate':
                    $res->startDate = StartDate::parse($curNode);
                    break;
                case 'EndDate':
                    $res->endDate = EndDate::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}