<?php


namespace Gek\AaApi\NewsML\NewsComponent;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "subjectOrSubjectMatterOrSubjectDetail" })
 *
 * Class SubjectCode
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class SubjectCode
{

    #region fields


    /**
     * XmlElements({
     * XmlElement(name = "Subject", type = NewsComponentType.DescriptiveMetadata.SubjectCode.Subject.class),
     * XmlElement(name = "SubjectMatter", type = NewsComponentType.DescriptiveMetadata.SubjectCode.SubjectMatter.class),
     * XmlElement(name = "SubjectDetail", type = NewsComponentType.DescriptiveMetadata.SubjectCode.SubjectDetail.class),
     * XmlElement(name = "SubjectQualifier", type = NewsComponentType.DescriptiveMetadata.SubjectCode.SubjectQualifier.class) })
     *
     * @var array|mixed[]|Subject[]|SubjectMatter[]|SubjectDetail[]|SubjectQualifier
     */
    protected array $subjectOrSubjectMatterOrSubjectDetail = array();

    /**
     * XmlAttribute(name = "AssignedBy")
     * @var string|null
     */
    protected ?string $assignedBy = null;

    /**
     * XmlAttribute(name = "Importance")
     * @var string|null
     */
    protected ?string $importance = null;
    /**
     * XmlAttribute(name = "Confidence")
     * @var string|null
     */
    protected ?string $confidence = null;

    /**
     * XmlAttribute(name = "HowPresent")
     * @var string|null
     */
    protected ?string $howPresent = null;
    /**
     * XmlAttribute(name = "DateAndTime")
     * @var string|null
     */
    protected ?string $dateAndTime = null;
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;
    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array|Subject[]|SubjectDetail[]|SubjectMatter[]|SubjectQualifier|mixed[]
     */
    public function getSubjectOrSubjectMatterOrSubjectDetail()
    {
        return $this->subjectOrSubjectMatterOrSubjectDetail;
    }

    /**
     * @param array|Subject[]|SubjectDetail[]|SubjectMatter[]|SubjectQualifier|mixed[] $subjectOrSubjectMatterOrSubjectDetail
     * @return SubjectCode
     */
    public function setSubjectOrSubjectMatterOrSubjectDetail($subjectOrSubjectMatterOrSubjectDetail)
    {
        $this->subjectOrSubjectMatterOrSubjectDetail = $subjectOrSubjectMatterOrSubjectDetail;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAssignedBy(): ?string
    {
        return $this->assignedBy;
    }

    /**
     * @param string|null $assignedBy
     * @return SubjectCode
     */
    public function setAssignedBy(?string $assignedBy): SubjectCode
    {
        $this->assignedBy = $assignedBy;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getImportance(): ?string
    {
        return $this->importance;
    }

    /**
     * @param string|null $importance
     * @return SubjectCode
     */
    public function setImportance(?string $importance): SubjectCode
    {
        $this->importance = $importance;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getConfidence(): ?string
    {
        return $this->confidence;
    }

    /**
     * @param string|null $confidence
     * @return SubjectCode
     */
    public function setConfidence(?string $confidence): SubjectCode
    {
        $this->confidence = $confidence;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getHowPresent(): ?string
    {
        return $this->howPresent;
    }

    /**
     * @param string|null $howPresent
     * @return SubjectCode
     */
    public function setHowPresent(?string $howPresent): SubjectCode
    {
        $this->howPresent = $howPresent;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDateAndTime(): ?string
    {
        return $this->dateAndTime;
    }

    /**
     * @param string|null $dateAndTime
     * @return SubjectCode
     */
    public function setDateAndTime(?string $dateAndTime): SubjectCode
    {
        $this->dateAndTime = $dateAndTime;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return SubjectCode
     */
    public function setDuid(?string $duid): SubjectCode
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return SubjectCode
     */
    public function setEuid(?string $euid): SubjectCode
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $assignedByAttr = $node->attributes->getNamedItem('AssignedBy');
            if (!empty($assignedByAttr)) {
                $res->assignedBy = (string)$assignedByAttr->nodeValue;
            }

            $importanceAttr = $node->attributes->getNamedItem('Importance');
            if (!empty($importanceAttr)) {
                $res->importance = (string)$importanceAttr->nodeValue;
            }

            $confidenceAttr = $node->attributes->getNamedItem('Confidence');
            if (!empty($confidenceAttr)) {
                $res->confidence = (string)$confidenceAttr->nodeValue;
            }

            $howPresentAttr = $node->attributes->getNamedItem('HowPresent');
            if (!empty($howPresentAttr)) {
                $res->howPresent = (string)$howPresentAttr->nodeValue;
            }

            $dateAndTimeAttr = $node->attributes->getNamedItem('DateAndTime');
            if (!empty($dateAndTimeAttr)) {
                $res->dateAndTime = (string)$dateAndTimeAttr->nodeValue;
            }

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }


        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Subject':
                    $res->subjectOrSubjectMatterOrSubjectDetail[] = Subject::parse($curNode);
                    break;
                case 'SubjectMatter':
                    $res->subjectOrSubjectMatterOrSubjectDetail[] = SubjectMatter::parse($curNode);
                    break;
                case 'SubjectDetail':
                    $res->subjectOrSubjectMatterOrSubjectDetail[] = SubjectDetail::parse($curNode);
                    break;
                case 'SubjectQualifier':
                    $res->subjectOrSubjectMatterOrSubjectDetail[] = SubjectQualifier::parse($curNode);
                    break;

            }

        }

        return $res;
    }

    #endregion statics

}