<?php


namespace Gek\AaApi\NewsML\NewsComponent;

use Gek\AaApi\NewsML\CommentType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "comment", "party" })
 * Class Source
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class Source
{

    #region fields

    /**
     * XmlElement(name = "Comment")
     * @var array|CommentType[]
     */
    protected array $comment = array();
    /**
     * XmlElement(name = "Party", required = true)
     * @var array|Party[]
     */
    protected array $party = array();
    /**
     * XmlAttribute(name = "NewsItem")
     * @var string|null
     */
    protected ?string $newsItem = null;
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;
    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array|CommentType[]
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @param array|CommentType[] $comment
     * @return Source
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return array|Party[]
     */
    public function getParty()
    {
        return $this->party;
    }

    /**
     * @param array|Party[] $party
     * @return Source
     */
    public function setParty($party)
    {
        $this->party = $party;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getNewsItem(): ?string
    {
        return $this->newsItem;
    }

    /**
     * @param string|null $newsItem
     * @return Source
     */
    public function setNewsItem(?string $newsItem): Source
    {
        $this->newsItem = $newsItem;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Source
     */
    public function setDuid(?string $duid): Source
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Source
     */
    public function setEuid(?string $euid): Source
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $newsItemAttr = $node->attributes->getNamedItem('NewsItem');
            if (!empty($newsItemAttr)) {
                $res->newsItem = (string)$newsItemAttr->nodeValue;
            }

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Comment':
                    $res->comment[] = CommentType::parse($curNode);
                    break;
                case 'Party':
                    $res->party[] = Party::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}