<?php


namespace Gek\AaApi\NewsML\NewsComponent;

use phpDocumentor\Reflection\Types\This;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "value" })
 * Class SizeInBytes
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class SizeInBytes
{

    #region fields

    /**
     * XmlValue
     * XmlSchemaType(name = "positiveInteger")
     * @var int
     */
    protected int $value = 0;
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;
    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct(int $value = 0)
    {
        $this->value = $value;
    }

    #endregion ctor

    #region properties

    /**
     * @return int
     */
    public function getValue(): int
    {
        return $this->value;
    }

    /**
     * @param int $value
     * @return SizeInBytes
     */
    public function setValue(int $value): SizeInBytes
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return SizeInBytes
     */
    public function setDuid(?string $duid): SizeInBytes
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return SizeInBytes
     */
    public function setEuid(?string $euid): SizeInBytes
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        $res->value = (int)$node->nodeValue;

        if ($node->hasAttributes()) {
            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }


        return $res;
    }

    #endregion statics

}