<?php


namespace Gek\AaApi\NewsML\NewsComponent;

use Gek\AaApi\NewsML\Catalog\CatalogType;
use Gek\AaApi\NewsML\PropertyType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "catalog", "copyright", "usageRights", "property" })
 *
 * Class RightsMetadata
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class RightsMetadata
{

    #region fields

    /**
     * XmlElement(name = "Catalog")
     *
     *
     * @var CatalogType|null
     */
    protected ?CatalogType $catalog = null;

    /**
     * XmlElement(name = "Copyright")
     *
     * @var array|Copyright[]
     */
    protected array $copyright = array();

    /**
     * XmlElement(name = "UsageRights")
     *
     * @var UsageRights|null
     */
    protected ?UsageRights $usageRights = null;

    /**
     * XmlElement(name = "Property")
     *
     * @var array|PropertyType[]
     */
    protected array $property = array();

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $duid = null;


    /**
     * XmlAttribute(name = "Euid")
     *
     * @var string|null
     */
    protected ?string $euid = null;

    /**
     * XmlAttribute(name = "AssignedBy")
     *
     * @var string|null
     */
    protected ?string $assignedBy = null;

    /**
     * XmlAttribute(name = "Importance")
     *
     * @var string|null
     */
    protected ?string $importance = null;

    /**
     * XmlAttribute(name = "Confidence")
     *
     * @var string|null
     */
    protected ?string $confidence = null;

    /**
     * XmlAttribute(name = "HowPresent")
     *
     * @var string|null
     */
    protected ?string $howPresent = null;

    /**
     * XmlAttribute(name = "DateAndTime")
     *
     * @var string|null
     */
    protected ?string $dateAndTime = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return CatalogType|null
     */
    public function getCatalog(): ?CatalogType
    {
        return $this->catalog;
    }

    /**
     * @param CatalogType|null $catalog
     * @return RightsMetadata
     */
    public function setCatalog(?CatalogType $catalog): RightsMetadata
    {
        $this->catalog = $catalog;
        return $this;
    }

    /**
     * @return array|Copyright[]
     */
    public function getCopyright()
    {
        return $this->copyright;
    }

    /**
     * @param array|Copyright[] $copyright
     * @return RightsMetadata
     */
    public function setCopyright($copyright)
    {
        $this->copyright = $copyright;
        return $this;
    }

    /**
     * @return UsageRights|null
     */
    public function getUsageRights(): ?UsageRights
    {
        return $this->usageRights;
    }

    /**
     * @param UsageRights|null $usageRights
     * @return RightsMetadata
     */
    public function setUsageRights(?UsageRights $usageRights): RightsMetadata
    {
        $this->usageRights = $usageRights;
        return $this;
    }

    /**
     * @return array|PropertyType[]
     */
    public function getProperty()
    {
        return $this->property;
    }

    /**
     * @param array|PropertyType[] $property
     * @return RightsMetadata
     */
    public function setProperty($property)
    {
        $this->property = $property;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return RightsMetadata
     */
    public function setDuid(?string $duid): RightsMetadata
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return RightsMetadata
     */
    public function setEuid(?string $euid): RightsMetadata
    {
        $this->euid = $euid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAssignedBy(): ?string
    {
        return $this->assignedBy;
    }

    /**
     * @param string|null $assignedBy
     * @return RightsMetadata
     */
    public function setAssignedBy(?string $assignedBy): RightsMetadata
    {
        $this->assignedBy = $assignedBy;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getImportance(): ?string
    {
        return $this->importance;
    }

    /**
     * @param string|null $importance
     * @return RightsMetadata
     */
    public function setImportance(?string $importance): RightsMetadata
    {
        $this->importance = $importance;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getConfidence(): ?string
    {
        return $this->confidence;
    }

    /**
     * @param string|null $confidence
     * @return RightsMetadata
     */
    public function setConfidence(?string $confidence): RightsMetadata
    {
        $this->confidence = $confidence;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getHowPresent(): ?string
    {
        return $this->howPresent;
    }

    /**
     * @param string|null $howPresent
     * @return RightsMetadata
     */
    public function setHowPresent(?string $howPresent): RightsMetadata
    {
        $this->howPresent = $howPresent;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDateAndTime(): ?string
    {
        return $this->dateAndTime;
    }

    /**
     * @param string|null $dateAndTime
     * @return RightsMetadata
     */
    public function setDateAndTime(?string $dateAndTime): RightsMetadata
    {
        $this->dateAndTime = $dateAndTime;
        return $this;
    }


    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }

            $assignedByAttr = $node->attributes->getNamedItem('AssignedBy');
            if (!empty($assignedByAttr)) {
                $res->assignedBy = (string)$assignedByAttr->nodeValue;
            }

            $importanceAttr = $node->attributes->getNamedItem('Importance');
            if (!empty($importanceAttr)) {
                $res->importance = (string)$importanceAttr->nodeValue;
            }

            $confidenceAttr = $node->attributes->getNamedItem('Confidence');
            if (!empty($confidenceAttr)) {
                $res->confidence = (string)$confidenceAttr->nodeValue;
            }

            $howPresentAttr = $node->attributes->getNamedItem('HowPresent');
            if (!empty($howPresentAttr)) {
                $res->howPresent = (string)$howPresentAttr->nodeValue;
            }

            $dateAndTimeAttr = $node->attributes->getNamedItem('DateAndTime');
            if (!empty($dateAndTimeAttr)) {
                $res->dateAndTime = (string)$dateAndTimeAttr->nodeValue;
            }

        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Catalog':
                    $res->catalog = CatalogType::parse($curNode);
                    break;
                case 'Copyright':
                    $res->copyright[] = Copyright::parse($curNode);
                    break;
                case 'UsageRights':
                    $res->usageRights = UsageRights::parse($curNode);
                    break;
                case 'Property':
                    $res->property[] = PropertyType::parse($curNode);
                    break;


            }

        }

        return $res;
    }

    #endregion statics

}