<?php


namespace Gek\AaApi\NewsML\NewsComponent;

use Gek\AaApi\NewsML\PropertyType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "property" })
 * Class Party
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class Party
{

    #region fields

    /**
     * XmlElement(name = "Property")
     * @var array|PropertyType[]
     */
    protected array $property = array();

    /**
     * XmlAttribute(name = "Topic")
     * @var string|null
     */
    protected ?string $topic = null;
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;
    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    /**
     * XmlAttribute(name = "FormalName", required = true)
     * @var string
     */
    protected string $formalName;

    /**
     * XmlAttribute(name = "Vocabulary")
     * @var string|null
     */
    protected ?string $vocabulary = null;
    /**
     * XmlAttribute(name = "Scheme")
     * @var string|null
     */
    protected ?string $scheme = null;

    #endregion fields

    #region ctor

    public function __construct(string $formalName = "")
    {
        $this->formalName = $formalName;
    }

    #endregion ctor

    #region properties

    /**
     * @return array|PropertyType[]
     */
    public function getProperty()
    {
        return $this->property;
    }

    /**
     * @param array|PropertyType[] $property
     * @return Party
     */
    public function setProperty($property)
    {
        $this->property = $property;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTopic(): ?string
    {
        return $this->topic;
    }

    /**
     * @param string|null $topic
     * @return Party
     */
    public function setTopic(?string $topic): Party
    {
        $this->topic = $topic;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Party
     */
    public function setDuid(?string $duid): Party
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Party
     */
    public function setEuid(?string $euid): Party
    {
        $this->euid = $euid;
        return $this;
    }

    /**
     * @return string
     */
    public function getFormalName(): string
    {
        return $this->formalName;
    }

    /**
     * @param string $formalName
     * @return Party
     */
    public function setFormalName(string $formalName): Party
    {
        $this->formalName = $formalName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getVocabulary(): ?string
    {
        return $this->vocabulary;
    }

    /**
     * @param string|null $vocabulary
     * @return Party
     */
    public function setVocabulary(?string $vocabulary): Party
    {
        $this->vocabulary = $vocabulary;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getScheme(): ?string
    {
        return $this->scheme;
    }

    /**
     * @param string|null $scheme
     * @return Party
     */
    public function setScheme(?string $scheme): Party
    {
        $this->scheme = $scheme;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node):self {
        $res = new self();

        if ($node->hasAttributes()) {

            $topicAttr = $node->attributes->getNamedItem('Topic');
            if (!empty($topicAttr)) {
                $res->topic = (string)$topicAttr->nodeValue;
            }

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }

            $formalNameAttr = $node->attributes->getNamedItem('FormalName');
            if (!empty($formalNameAttr)) {
                $res->formalName = (string)$formalNameAttr->nodeValue;
            }

            $vocabularyNameAttr = $node->attributes->getNamedItem('Vocabulary');
            if (!empty($vocabularyNameAttr)) {
                $res->vocabulary = (string)$vocabularyNameAttr->nodeValue;
            }

            $schemeNameAttr = $node->attributes->getNamedItem('Scheme');
            if (!empty($schemeNameAttr)) {
                $res->scheme = (string)$schemeNameAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Property':
                    $res->property[] = PropertyType::parse($curNode);
                    break;

            }
        }


        return $res;
    }

    #endregion statics

}