<?php


namespace Gek\AaApi\NewsML\NewsComponent;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "headLineAndSubHeadLineOrByLine" })
 *
 * Class NewsLines
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class NewsLines
{

    #region fields

    /**
     * XmlElements({ @XmlElement(name = "HeadLine", type = NewsComponentType.NewsLines.HeadLine.class),
     * XmlElement(name = "SubHeadLine", type = NewsComponentType.NewsLines.SubHeadLine.class),
     * XmlElement(name = "ByLine", type = NewsComponentType.NewsLines.ByLine.class),
     * XmlElement(name = "ByLineTitle", type = NewsComponentType.NewsLines.ByLineTitle.class),
     * XmlElement(name = "DateLine", type = NewsComponentType.NewsLines.DateLine.class),
     * XmlElement(name = "CreditLine", type = NewsComponentType.NewsLines.CreditLine.class),
     * XmlElement(name = "CopyrightLine", type = NewsComponentType.NewsLines.CopyrightLine.class),
     * XmlElement(name = "RightsLine", type = NewsComponentType.NewsLines.RightsLine.class),
     * XmlElement(name = "SeriesLine", type = NewsComponentType.NewsLines.SeriesLine.class),
     * XmlElement(name = "SlugLine", type = NewsComponentType.NewsLines.SlugLine.class),
     * XmlElement(name = "KeywordLine", type = NewsComponentType.NewsLines.KeywordLine.class),
     * XmlElement(name = "NewsLine", type = NewsComponentType.NewsLines.NewsLine.class) })
     *
     * @var array|mixed[]
     */
    protected array $headLineAndSubHeadLineOrByLine = array();

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     *
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array|mixed[]
     */
    public function getHeadLineAndSubHeadLineOrByLine()
    {
        return $this->headLineAndSubHeadLineOrByLine;
    }

    /**
     * @param array|mixed[] $headLineAndSubHeadLineOrByLine
     * @return NewsLines
     */
    public function setHeadLineAndSubHeadLineOrByLine($headLineAndSubHeadLineOrByLine)
    {
        $this->headLineAndSubHeadLineOrByLine = $headLineAndSubHeadLineOrByLine;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return NewsLines
     */
    public function setDuid(?string $duid): NewsLines
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return NewsLines
     */
    public function setEuid(?string $euid): NewsLines
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();


        if ($node->hasAttributes()) {
            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'HeadLine':
                    $res->headLineAndSubHeadLineOrByLine[] = HeadLine::parse($curNode);
                    break;
                case 'SubHeadLine':
                    $res->headLineAndSubHeadLineOrByLine[] = SubHeadLine::parse($curNode);
                    break;
                case 'ByLine':
                    $res->headLineAndSubHeadLineOrByLine[] = ByLine::parse($curNode);
                    break;
                case 'ByLineTitle':
                    $res->headLineAndSubHeadLineOrByLine[] = ByLineTitle::parse($curNode);
                    break;
                case 'DateLine':
                    $res->headLineAndSubHeadLineOrByLine[] = DateLine::parse($curNode);
                    break;
                case 'CreditLine':
                    $res->headLineAndSubHeadLineOrByLine[] = CreditLine::parse($curNode);
                    break;
                case 'CopyrightLine':
                    $res->headLineAndSubHeadLineOrByLine[] = CopyrightLine::parse($curNode);
                    break;
                case 'RightsLine':
                    $res->headLineAndSubHeadLineOrByLine[] = RightsLine::parse($curNode);
                    break;
                case 'SeriesLine':
                    $res->headLineAndSubHeadLineOrByLine[] = SeriesLine::parse($curNode);
                    break;
                case 'SlugLine':
                    $res->headLineAndSubHeadLineOrByLine[] = SlugLine::parse($curNode);
                    break;
                case 'KeywordLine':
                    $res->headLineAndSubHeadLineOrByLine[] = KeywordLine::parse($curNode);
                    break;
                case 'NewsLine':
                    $res->headLineAndSubHeadLineOrByLine[] = NewsLine::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}