<?php


namespace Gek\AaApi\NewsML\NewsComponent;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "newsLineType", "newsLineText" })
 *
 * Class NewsLine
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class NewsLine
{

    #region fields

    /**
     * XmlElement(name = "NewsLineType", required = true)
     *
     * @var NewsLineType|null
     */
    protected ?NewsLineType $newsLineType = null;

    /**
     * XmlElement(name = "NewsLineText", required = true)
     *
     * @var NewsLineText|null
     */
    protected ?NewsLineText $newsLineText = null;

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     *
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct(?NewsLineType $newsLineType = null, ?NewsLineText $newsLineText = null )
    {
        $this->newsLineType = $newsLineType;
        $this->newsLineText = $newsLineText;
    }

    #endregion ctor

    #region properties

    /**
     * @return NewsLineType|null
     */
    public function getNewsLineType(): ?NewsLineType
    {
        return $this->newsLineType;
    }

    /**
     * @param NewsLineType|null $newsLineType
     * @return NewsLine
     */
    public function setNewsLineType(?NewsLineType $newsLineType): NewsLine
    {
        $this->newsLineType = $newsLineType;
        return $this;
    }

    /**
     * @return NewsLineText|null
     */
    public function getNewsLineText(): ?NewsLineText
    {
        return $this->newsLineText;
    }

    /**
     * @param NewsLineText|null $newsLineText
     * @return NewsLine
     */
    public function setNewsLineText(?NewsLineText $newsLineText): NewsLine
    {
        $this->newsLineText = $newsLineText;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return NewsLine
     */
    public function setDuid(?string $duid): NewsLine
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return NewsLine
     */
    public function setEuid(?string $euid): NewsLine
    {
        $this->euid = $euid;
        return $this;
    }


    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);
            switch ($curNode->nodeName) {
                case 'NewsLineType':
                    $res->newsLineType = NewsLineType::parse($curNode);
                    break;
                case 'NewsLineText':
                    $res->newsLineText = NewsLineText::parse($curNode);
                    break;
            }
        }

        return $res;
    }

    #endregion statics

}