<?php


namespace Gek\AaApi\NewsML\NewsComponent;

use Gek\AaApi\NewsML\CommentType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "comment" })
 *
 * Class NewsItemRef
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class NewsItemRef
{

    #region fields

    /**
     * XmlElement(name = "Comment")
     *
     * @var array|CommentType[]
     */
    protected array $comment = array();

    /**
     * XmlAttribute(name = "NewsItem")
     * @var string|null
     */
    protected ?string $newsItem = null;

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     *
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array|CommentType[]
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @param array|CommentType[] $comment
     * @return NewsItemRef
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getNewsItem(): ?string
    {
        return $this->newsItem;
    }

    /**
     * @param string|null $newsItem
     * @return NewsItemRef
     */
    public function setNewsItem(?string $newsItem): NewsItemRef
    {
        $this->newsItem = $newsItem;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return NewsItemRef
     */
    public function setDuid(?string $duid): NewsItemRef
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return NewsItemRef
     */
    public function setEuid(?string $euid): NewsItemRef
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
            $newsItemAttr = $node->attributes->getNamedItem('NewsItem');
            if (!empty($newsItemAttr)) {
                $res->newsItem = (string)$newsItemAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Comment':
                    $res->comment[] = CommentType::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}