<?php


namespace Gek\AaApi\NewsML\NewsComponent;

use Gek\AaApi\NewsML\Catalog\CatalogType;
use Gek\AaApi\NewsML\CommentType;
use Gek\AaApi\NewsML\NewsItemType\NewsItemType;
use Gek\AaApi\NewsML\TopicSet\TopicSetType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "NewsComponentType", propOrder = { "comment", "catalog", "topicSet", "role", "basisForChoice",
 * "newsLines", "administrativeMetadata", "rightsMetadata", "descriptiveMetadata", "metadata",
 * "newsItemOrNewsItemRef", "newsComponent", "contentItem" })
 * Class NewsComponentType
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class NewsComponentType
{

    #region fields

    /**
     * XmlElement(name = "Comment")
     * @var array|CommentType[]
     */
protected array $comment = array();
    /**
     * XmlElement(name = "Catalog")
     * @var CatalogType|null
     */
    protected ?CatalogType $catalog = null;

    /**
     * XmlElement(name = "TopicSet")
     * @var array|TopicSetType[]
     */
	protected array $topicSet = array();
    /**
     * XmlElement(name = "Role")
     * @var Role|null
     */
	protected ?Role $role = null;
    /**
     * XmlElement(name = "BasisForChoice")
     * @var array|BasisForChoice[]
     */
	protected array $basisForChoice = array();

    /**
     * XmlElement(name = "NewsLines")
     * @var NewsLines|null
     */
	protected ?NewsLines $newsLines = null;

    /**
     * XmlElement(name = "AdministrativeMetadata")
     * @var AdministrativeMetadata|null
     */
	protected ?AdministrativeMetadata $administrativeMetadata = null;

    /**
     * XmlElement(name = "RightsMetadata")
     * @var RightsMetadata|null
     */
	protected ?RightsMetadata $rightsMetadata = null;

    /**
     * XmlElement(name = "DescriptiveMetadata")
     * @var DescriptiveMetadata|null
     */
	protected ?DescriptiveMetadata $descriptiveMetadata = null;

    /**
     * XmlElement(name = "Metadata")
     * @var array|Metadata[]
     */
	protected array $metadata = array();
    /**
     * XmlElements({ XmlElement(name = "NewsItem", type = NewsItemType.class),
     * XmlElement(name = "NewsItemRef", type = NewsComponentType.NewsItemRef.class) })
     * @var array|mixed[]
     */
protected array $newsItemOrNewsItemRef = array();
    /**
     * XmlElement(name = "NewsComponent")
     * @var array|NewsComponentType[]
     */
	protected array $newsComponent = array();

    /**
     * XmlElement(name = "ContentItem")
     * @var array|ContentItem[]
     */
	protected array $contentItem = array();
    /**
     * XmlAttribute(name = "Essential")
     * XmlJavaTypeAdapter(CollapsedStringAdapter.class)
     * @var string|null
     */
	protected ?string $essential = null;

    /**
     * XmlAttribute(name = "EquivalentsList")
     * XmlJavaTypeAdapter(CollapsedStringAdapter.class)
     * @var string|null
     */
	protected ?string $equivalentsList = null;

    /**
     * XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
     * XmlJavaTypeAdapter(CollapsedStringAdapter.class)
     * XmlSchemaType(name = "language")
     * @var string|null
     */
	protected ?string $lang = null;

    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
	protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
	protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array|CommentType[]
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @param array|CommentType[] $comment
     * @return NewsComponentType
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return CatalogType|null
     */
    public function getCatalog(): ?CatalogType
    {
        return $this->catalog;
    }

    /**
     * @param CatalogType|null $catalog
     * @return NewsComponentType
     */
    public function setCatalog(?CatalogType $catalog): NewsComponentType
    {
        $this->catalog = $catalog;
        return $this;
    }

    /**
     * @return array|TopicSetType[]
     */
    public function getTopicSet()
    {
        return $this->topicSet;
    }

    /**
     * @param array|TopicSetType[] $topicSet
     * @return NewsComponentType
     */
    public function setTopicSet($topicSet)
    {
        $this->topicSet = $topicSet;
        return $this;
    }

    /**
     * @return Role|null
     */
    public function getRole(): ?Role
    {
        return $this->role;
    }

    /**
     * @param Role|null $role
     * @return NewsComponentType
     */
    public function setRole(?Role $role): NewsComponentType
    {
        $this->role = $role;
        return $this;
    }

    /**
     * @return array|BasisForChoice[]
     */
    public function getBasisForChoice()
    {
        return $this->basisForChoice;
    }

    /**
     * @param array|BasisForChoice[] $basisForChoice
     * @return NewsComponentType
     */
    public function setBasisForChoice($basisForChoice)
    {
        $this->basisForChoice = $basisForChoice;
        return $this;
    }

    /**
     * @return NewsLines|null
     */
    public function getNewsLines(): ?NewsLines
    {
        return $this->newsLines;
    }

    /**
     * @param NewsLines|null $newsLines
     * @return NewsComponentType
     */
    public function setNewsLines(?NewsLines $newsLines): NewsComponentType
    {
        $this->newsLines = $newsLines;
        return $this;
    }

    /**
     * @return AdministrativeMetadata|null
     */
    public function getAdministrativeMetadata(): ?AdministrativeMetadata
    {
        return $this->administrativeMetadata;
    }

    /**
     * @param AdministrativeMetadata|null $administrativeMetadata
     * @return NewsComponentType
     */
    public function setAdministrativeMetadata(?AdministrativeMetadata $administrativeMetadata): NewsComponentType
    {
        $this->administrativeMetadata = $administrativeMetadata;
        return $this;
    }

    /**
     * @return RightsMetadata|null
     */
    public function getRightsMetadata(): ?RightsMetadata
    {
        return $this->rightsMetadata;
    }

    /**
     * @param RightsMetadata|null $rightsMetadata
     * @return NewsComponentType
     */
    public function setRightsMetadata(?RightsMetadata $rightsMetadata): NewsComponentType
    {
        $this->rightsMetadata = $rightsMetadata;
        return $this;
    }

    /**
     * @return DescriptiveMetadata|null
     */
    public function getDescriptiveMetadata(): ?DescriptiveMetadata
    {
        return $this->descriptiveMetadata;
    }

    /**
     * @param DescriptiveMetadata|null $descriptiveMetadata
     * @return NewsComponentType
     */
    public function setDescriptiveMetadata(?DescriptiveMetadata $descriptiveMetadata): NewsComponentType
    {
        $this->descriptiveMetadata = $descriptiveMetadata;
        return $this;
    }

    /**
     * @return array|Metadata[]
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    /**
     * @param array|Metadata[] $metadata
     * @return NewsComponentType
     */
    public function setMetadata($metadata)
    {
        $this->metadata = $metadata;
        return $this;
    }

    /**
     * @return array|mixed[]
     */
    public function getNewsItemOrNewsItemRef()
    {
        return $this->newsItemOrNewsItemRef;
    }

    /**
     * @param array|mixed[] $newsItemOrNewsItemRef
     * @return NewsComponentType
     */
    public function setNewsItemOrNewsItemRef($newsItemOrNewsItemRef)
    {
        $this->newsItemOrNewsItemRef = $newsItemOrNewsItemRef;
        return $this;
    }

    /**
     * @return array|NewsComponentType[]
     */
    public function getNewsComponent()
    {
        return $this->newsComponent;
    }

    /**
     * @param array|NewsComponentType[] $newsComponent
     * @return NewsComponentType
     */
    public function setNewsComponent($newsComponent)
    {
        $this->newsComponent = $newsComponent;
        return $this;
    }

    /**
     * @return array|ContentItem[]
     */
    public function getContentItem()
    {
        return $this->contentItem;
    }

    /**
     * @param array|ContentItem[] $contentItem
     * @return NewsComponentType
     */
    public function setContentItem($contentItem)
    {
        $this->contentItem = $contentItem;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEssential(): ?string
    {
        return $this->essential;
    }

    /**
     * @param string|null $essential
     * @return NewsComponentType
     */
    public function setEssential(?string $essential): NewsComponentType
    {
        $this->essential = $essential;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEquivalentsList(): ?string
    {
        return $this->equivalentsList;
    }

    /**
     * @param string|null $equivalentsList
     * @return NewsComponentType
     */
    public function setEquivalentsList(?string $equivalentsList): NewsComponentType
    {
        $this->equivalentsList = $equivalentsList;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getLang(): ?string
    {
        return $this->lang;
    }

    /**
     * @param string|null $lang
     * @return NewsComponentType
     */
    public function setLang(?string $lang): NewsComponentType
    {
        $this->lang = $lang;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return NewsComponentType
     */
    public function setDuid(?string $duid): NewsComponentType
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return NewsComponentType
     */
    public function setEuid(?string $euid): NewsComponentType
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $essentialAttr = $node->attributes->getNamedItem('Essential');
            if (!empty($essentialAttr)) {
                $res->essential = (string)$essentialAttr->nodeValue;
            }

            $qquivalentsListAttr = $node->attributes->getNamedItem('EquivalentsList');
            if (!empty($qquivalentsListAttr)) {
                $res->equivalentsList = (string)$qquivalentsListAttr->nodeValue;
            }

            $langAttr = $node->attributes->getNamedItem('lang');
            if (!empty($langAttr)) {
                $res->lang = (string)$langAttr->nodeValue;
                $res->lang = (string)$langAttr->nodeValue;
            }

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Comment':
                    $res->comment[] = CommentType::parse($curNode);
                    break;
                case 'Catalog':
                    $res->catalog = CatalogType::parse($curNode);
                    break;
                case 'TopicSet':
                    $res->topicSet[] = TopicSetType::parse($curNode);
                    break;
                case 'Role':
                    $res->role = Role::parse($curNode);
                    break;
                case 'BasisForChoice':
                    $res->basisForChoice[] = BasisForChoice::parse($curNode);
                    break;
                case 'NewsLines':
                    $res->newsLines = NewsLines::parse($curNode);
                    break;
                case 'AdministrativeMetadata':
                    $res->administrativeMetadata = AdministrativeMetadata::parse($curNode);
                    break;
                case 'RightsMetadata':
                    $res->rightsMetadata = RightsMetadata::parse($curNode);
                    break;
                case 'DescriptiveMetadata':
                    $res->descriptiveMetadata = DescriptiveMetadata::parse($curNode);
                    break;
                case 'Metadata':
                    $res->metadata[] = Metadata::parse($curNode);
                    break;
                case 'NewsItem':
                    $res->newsItemOrNewsItemRef[] = NewsItemType::parse($curNode);
                    break;
                case 'NewsItemRef':
                    $res->newsItemOrNewsItemRef[] = NewsItemRef::parse($curNode);
                    break;
                case 'NewsComponent':
                    $res->newsComponent[] = NewsComponentType::parse($curNode);
                    break;
                case 'ContentItem':
                    $res->contentItem[] = ContentItem::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}