<?php


namespace Gek\AaApi\NewsML\NewsComponent;

use Gek\AaApi\NewsML\Catalog\CatalogType;
use Gek\AaApi\NewsML\PropertyType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "catalog", "metadataType", "property" })
 *
 * Class Metadata
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class Metadata
{

    #region fields

    /**
     * XmlElement(name = "Catalog")
     *
     * @var CatalogType|null
     */
    protected ?CatalogType $catalog;

    /**
     * XmlElement(name = "MetadataType", required = true)
     *
     * @var MetadataType|null
     */
    protected ?MetadataType $metadataType = null;

    /**
     * XmlElement(name = "Property", required = true)
     *
     * @var PropertyType|null
     */
    protected ?PropertyType $property = null;

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     *
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return CatalogType|null
     */
    public function getCatalog(): ?CatalogType
    {
        return $this->catalog;
    }

    /**
     * @param CatalogType|null $catalog
     * @return Metadata
     */
    public function setCatalog(?CatalogType $catalog): Metadata
    {
        $this->catalog = $catalog;
        return $this;
    }

    /**
     * @return MetadataType|null
     */
    public function getMetadataType(): ?MetadataType
    {
        return $this->metadataType;
    }

    /**
     * @param MetadataType|null $metadataType
     * @return Metadata
     */
    public function setMetadataType(?MetadataType $metadataType): Metadata
    {
        $this->metadataType = $metadataType;
        return $this;
    }

    /**
     * @return PropertyType|null
     */
    public function getProperty(): ?PropertyType
    {
        return $this->property;
    }

    /**
     * @param PropertyType|null $property
     * @return Metadata
     */
    public function setProperty(?PropertyType $property): Metadata
    {
        $this->property = $property;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Metadata
     */
    public function setDuid(?string $duid): Metadata
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Metadata
     */
    public function setEuid(?string $euid): Metadata
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Catalog':
                    $res->catalog = CatalogType::parse($curNode);
                    break;
                case 'MetadataType':
                    $res->metadataType = MetadataType::parse($curNode);
                    break;
                case 'Property':
                    $res->property = PropertyType::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics
}