<?php


namespace Gek\AaApi\NewsML\NewsComponent;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "content" })
 *
 * Class Geography
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class Geography
{

    #region fields

    /**
     * XmlElementRef(name = "Origin", namespace = "http://iptc.org/std/NewsML/2003-10-10/", type = JAXBElement.class, required = false)
     * XmlMixed
     *
     * @var array|mixed[]
     */
    protected array $content = array();

    /**
     * XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
     *
     * @var string|null
     */
    protected ?string $lang = null;

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     *
     * @var string|null
     */
    protected ?string $euid = null;

    /**
     * XmlAttribute(name = "AssignedBy")
     *
     * @var string|null
     */
    protected ?string $assignedBy = null;

    /**
     * XmlAttribute(name = "Importance")
     *
     * @var string|null
     */
    protected ?string $importance = null;

    /**
     * XmlAttribute(name = "Confidence")
     *
     * @var string|null
     */
    protected ?string $confidence = null;

    /**
     * XmlAttribute(name = "HowPresent")
     *
     * @var string|null
     */
    protected ?string $howPresent = null;

    /**
     * XmlAttribute(name = "DateAndTime")
     *
     * @var string|null
     */
    protected ?string $dateAndTime = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array|mixed[]
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * @param array|mixed[] $content
     * @return Geography
     */
    public function setContent($content)
    {
        $this->content = $content;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getLang(): ?string
    {
        return $this->lang;
    }

    /**
     * @param string|null $lang
     * @return Geography
     */
    public function setLang(?string $lang): Geography
    {
        $this->lang = $lang;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Geography
     */
    public function setDuid(?string $duid): Geography
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Geography
     */
    public function setEuid(?string $euid): Geography
    {
        $this->euid = $euid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAssignedBy(): ?string
    {
        return $this->assignedBy;
    }

    /**
     * @param string|null $assignedBy
     * @return Geography
     */
    public function setAssignedBy(?string $assignedBy): Geography
    {
        $this->assignedBy = $assignedBy;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getImportance(): ?string
    {
        return $this->importance;
    }

    /**
     * @param string|null $importance
     * @return Geography
     */
    public function setImportance(?string $importance): Geography
    {
        $this->importance = $importance;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getConfidence(): ?string
    {
        return $this->confidence;
    }

    /**
     * @param string|null $confidence
     * @return Geography
     */
    public function setConfidence(?string $confidence): Geography
    {
        $this->confidence = $confidence;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getHowPresent(): ?string
    {
        return $this->howPresent;
    }

    /**
     * @param string|null $howPresent
     * @return Geography
     */
    public function setHowPresent(?string $howPresent): Geography
    {
        $this->howPresent = $howPresent;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDateAndTime(): ?string
    {
        return $this->dateAndTime;
    }

    /**
     * @param string|null $dateAndTime
     * @return Geography
     */
    public function setDateAndTime(?string $dateAndTime): Geography
    {
        $this->dateAndTime = $dateAndTime;
        return $this;
    }



    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $langAttr = $node->attributes->getNamedItem('lang');
            if (!empty($langAttr)) {
                $res->lang = (string)$langAttr->nodeValue;
            }

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }

            $assignedByAttr = $node->attributes->getNamedItem('AssignedBy');
            if (!empty($assignedByAttr)) {
                $res->assignedBy = (string)$assignedByAttr->nodeValue;
            }

            $importanceAttr = $node->attributes->getNamedItem('Importance');
            if (!empty($importanceAttr)) {
                $res->importance = (string)$importanceAttr->nodeValue;
            }

            $confidenceAttr = $node->attributes->getNamedItem('Confidence');
            if (!empty($confidenceAttr)) {
                $res->confidence = (string)$confidenceAttr->nodeValue;
            }



            $dateAndTimeAttr = $node->attributes->getNamedItem('DateAndTime');
            if (!empty($dateAndTimeAttr)) {
                $res->dateAndTime = (string)$dateAndTimeAttr->nodeValue;
            }

        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            $res->content[] = (string)$curNode->nodeValue;
        }

        return $res;
    }

    #endregion statics

}