<?php


namespace Gek\AaApi\NewsML\NewsComponent;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "")
 *
 * Class Genre
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class Genre
{

    #region fields

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     *
     * @var string|null
     */
    protected ?string $euid = null;


    /**
     * XmlAttribute(name = "AssignedBy")
     *
     * @var string|null
     */
    protected ?string $assignedBy = null;

    /**
     * XmlAttribute(name = "Importance")
     *
     * @var string|null
     */
    protected ?string $importance = null;

    /**
     * XmlAttribute(name = "Confidence")
     *
     * @var string|null
     */
    protected ?string $confidence = null;

    /**
     * XmlAttribute(name = "HowPresent")
     *
     * @var string|null
     */
    protected ?string $howPresent = null;

    /**
     * XmlAttribute(name = "DateAndTime")
     *
     * @var string|null
     */
    protected ?string $dateAndTime = null;

    /**
     * XmlAttribute(name = "FormalName", required = true)
     * @var string|null
     */
    protected ?string $formalName = null;

    /**
     * XmlAttribute(name = "Vocabulary")
     * @var string|null
     */
    protected ?string $vocabulary = null;

    /**
     * XmlAttribute(name = "Scheme")
     * @var string|null
     */
    protected ?string $scheme = null;

    #endregion fields

    #region properties

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Genre
     */
    public function setDuid(?string $duid): Genre
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Genre
     */
    public function setEuid(?string $euid): Genre
    {
        $this->euid = $euid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAssignedBy(): ?string
    {
        return $this->assignedBy;
    }

    /**
     * @param string|null $assignedBy
     * @return Genre
     */
    public function setAssignedBy(?string $assignedBy): Genre
    {
        $this->assignedBy = $assignedBy;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getImportance(): ?string
    {
        return $this->importance;
    }

    /**
     * @param string|null $importance
     * @return Genre
     */
    public function setImportance(?string $importance): Genre
    {
        $this->importance = $importance;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getConfidence(): ?string
    {
        return $this->confidence;
    }

    /**
     * @param string|null $confidence
     * @return Genre
     */
    public function setConfidence(?string $confidence): Genre
    {
        $this->confidence = $confidence;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getHowPresent(): ?string
    {
        return $this->howPresent;
    }

    /**
     * @param string|null $howPresent
     * @return Genre
     */
    public function setHowPresent(?string $howPresent): Genre
    {
        $this->howPresent = $howPresent;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDateAndTime(): ?string
    {
        return $this->dateAndTime;
    }

    /**
     * @param string|null $dateAndTime
     * @return Genre
     */
    public function setDateAndTime(?string $dateAndTime): Genre
    {
        $this->dateAndTime = $dateAndTime;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFormalName(): ?string
    {
        return $this->formalName;
    }

    /**
     * @param string|null $formalName
     * @return Genre
     */
    public function setFormalName(?string $formalName): Genre
    {
        $this->formalName = $formalName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getVocabulary(): ?string
    {
        return $this->vocabulary;
    }

    /**
     * @param string|null $vocabulary
     * @return Genre
     */
    public function setVocabulary(?string $vocabulary): Genre
    {
        $this->vocabulary = $vocabulary;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getScheme(): ?string
    {
        return $this->scheme;
    }

    /**
     * @param string|null $scheme
     * @return Genre
     */
    public function setScheme(?string $scheme): Genre
    {
        $this->scheme = $scheme;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $assignedByAttr = $node->attributes->getNamedItem('AssignedBy');
            if (!empty($assignedByAttr)) {
                $res->assignedBy = (string)$assignedByAttr->nodeValue;
            }

            $importanceAttr = $node->attributes->getNamedItem('Importance');
            if (!empty($importanceAttr)) {
                $res->importance = (string)$importanceAttr->nodeValue;
            }

            $confidenceAttr = $node->attributes->getNamedItem('Confidence');
            if (!empty($confidenceAttr)) {
                $res->confidence = (string)$confidenceAttr->nodeValue;
            }

            $howPresentAttr = $node->attributes->getNamedItem('HowPresent');
            if (!empty($howPresentAttr)) {
                $res->howPresent = (string)$howPresentAttr->nodeValue;
            }

            $dateAndTimeAttr = $node->attributes->getNamedItem('DateAndTime');
            if (!empty($dateAndTimeAttr)) {
                $res->dateAndTime = (string)$dateAndTimeAttr->nodeValue;
            }

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }

            $formalNameAttr = $node->attributes->getNamedItem('FormalName');
            if (!empty($formalNameAttr)) {
                $res->formalName = (string)$formalNameAttr->nodeValue;
            }

            $vocabularyAttr = $node->attributes->getNamedItem('Vocabulary');
            if (!empty($vocabularyAttr)) {
                $res->vocabulary = (string)$vocabularyAttr->nodeValue;
            }

            $schemeAttr = $node->attributes->getNamedItem('Scheme');
            if (!empty($schemeAttr)) {
                $res->scheme = (string)$schemeAttr->nodeValue;
            }

        }

        return $res;
    }

    #endregion statics

}