<?php


namespace Gek\AaApi\NewsML\NewsComponent;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "encoding", "dataContent" })
 * Class Encoding
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class Encoding
{

    #region fields

    /**
     * XmlElement(name = "Encoding")
     * @var Encoding|null
     */
    protected ?Encoding $encoding = null;
    /**
     * XmlElement(name = "DataContent")
     * @var DataContent|null
     */
    protected ?DataContent $dataContent = null;
    /**
     * XmlAttribute(name = "Notation", required = true)
     * @var string|null
     */
    protected ?string $notation = null;
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;
    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;


    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return Encoding|null
     */
    public function getEncoding(): ?Encoding
    {
        return $this->encoding;
    }

    /**
     * @param Encoding|null $encoding
     * @return Encoding
     */
    public function setEncoding(?Encoding $encoding): Encoding
    {
        $this->encoding = $encoding;
        return $this;
    }

    /**
     * @return DataContent|null
     */
    public function getDataContent(): ?DataContent
    {
        return $this->dataContent;
    }

    /**
     * @param DataContent|null $dataContent
     * @return Encoding
     */
    public function setDataContent(?DataContent $dataContent): Encoding
    {
        $this->dataContent = $dataContent;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getNotation(): ?string
    {
        return $this->notation;
    }

    /**
     * @param string|null $notation
     * @return Encoding
     */
    public function setNotation(?string $notation): Encoding
    {
        $this->notation = $notation;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Encoding
     */
    public function setDuid(?string $duid): Encoding
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Encoding
     */
    public function setEuid(?string $euid): Encoding
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
            $NotationAttr = $node->attributes->getNamedItem('Notation');
            if (!empty($NotationAttr)) {
                $res->notation = (string)$NotationAttr->nodeValue;
            }

        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Encoding':
                    $res->encoding = Encoding::parse($curNode);
                    break;
                case 'DataContent':
                    $res->dataContent = DataContent::parse($curNode);
                    break;

            }
        }

        return $res;
    }

    #endregion statics

}