<?php


namespace Gek\AaApi\NewsML\NewsComponent;

use Gek\AaApi\NewsML\Catalog\CatalogType;
use Gek\AaApi\NewsML\PropertyType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "catalog", "language", "genre", "subjectCode", "ofInterestTo", "dateLineDate",
 * "location", "topicOccurrence", "property" })
 *
 * Class DescriptiveMetadata
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class DescriptiveMetadata
{

    #region fields

    /**
     * XmlElement(name = "Catalog")
     * @var CatalogType|null
     */
    protected ?CatalogType $catalog = null;
    /**
     * XmlElement(name = "Language")
     * @var array|Language[]
     */
    protected array $language = array();

    /**
     * XmlElement(name = "Genre")
     * @var array|Genre[]
     */
    protected array $genre = array();
    /**
     * XmlElement(name = "SubjectCode")
     * @var array|SubjectCode[]
     */
    protected array $subjectCode = array();

    /**
     * XmlElement(name = "OfInterestTo")
     * @var array|OfInterestTo[]
     */
    protected array $ofInterestTo = array();

    /**
     * XmlElement(name = "DateLineDate")
     * @var DateLineDate|null
     */
    protected ?DateLineDate $dateLineDate = null;
    /**
     * XmlElement(name = "Location")
     * @var array|Location[]
     */
    protected array $location = array();

    /**
     * XmlElement(name = "TopicOccurrence")
     * @var array|TopicOccurrence[]
     */
    protected array $topicOccurrence = array();

    /**
     * XmlElement(name = "Property")
     * @var array|PropertyType[]
     */
    protected array $property = array();
    /**
     * XmlAttribute(name = "AssignedBy")
     * @var string|null
     */
    protected ?string $assignedBy = null;
    /**
     * XmlAttribute(name = "Importance")
     * @var string|null
     */
    protected ?string $importance = null;
    /**
     * XmlAttribute(name = "Confidence")
     * @var string|null
     */
    protected ?string $confidence = null;
    /**
     * XmlAttribute(name = "HowPresent")
     * @var string|null
     */
    protected ?string $howPresent = null;
    /**
     * XmlAttribute(name = "DateAndTime")
     * @var string|null
     */
    protected ?string $dateAndTime = null;
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return CatalogType|null
     */
    public function getCatalog(): ?CatalogType
    {
        return $this->catalog;
    }

    /**
     * @param CatalogType|null $catalog
     * @return DescriptiveMetadata
     */
    public function setCatalog(?CatalogType $catalog): DescriptiveMetadata
    {
        $this->catalog = $catalog;
        return $this;
    }

    /**
     * @return array|Language[]
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * @param array|Language[] $language
     * @return DescriptiveMetadata
     */
    public function setLanguage($language)
    {
        $this->language = $language;
        return $this;
    }

    /**
     * @return array|Genre[]
     */
    public function getGenre()
    {
        return $this->genre;
    }

    /**
     * @param array|Genre[] $genre
     * @return DescriptiveMetadata
     */
    public function setGenre($genre)
    {
        $this->genre = $genre;
        return $this;
    }

    /**
     * @return array|SubjectCode[]
     */
    public function getSubjectCode()
    {
        return $this->subjectCode;
    }

    /**
     * @param array|SubjectCode[] $subjectCode
     * @return DescriptiveMetadata
     */
    public function setSubjectCode($subjectCode)
    {
        $this->subjectCode = $subjectCode;
        return $this;
    }

    /**
     * @return array|OfInterestTo[]
     */
    public function getOfInterestTo()
    {
        return $this->ofInterestTo;
    }

    /**
     * @param array|OfInterestTo[] $ofInterestTo
     * @return DescriptiveMetadata
     */
    public function setOfInterestTo($ofInterestTo)
    {
        $this->ofInterestTo = $ofInterestTo;
        return $this;
    }

    /**
     * @return DateLineDate|null
     */
    public function getDateLineDate(): ?DateLineDate
    {
        return $this->dateLineDate;
    }

    /**
     * @param DateLineDate|null $dateLineDate
     * @return DescriptiveMetadata
     */
    public function setDateLineDate(?DateLineDate $dateLineDate): DescriptiveMetadata
    {
        $this->dateLineDate = $dateLineDate;
        return $this;
    }

    /**
     * @return array|Location[]
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * @param array|Location[] $location
     * @return DescriptiveMetadata
     */
    public function setLocation($location)
    {
        $this->location = $location;
        return $this;
    }

    /**
     * @return array|TopicOccurrence[]
     */
    public function getTopicOccurrence()
    {
        return $this->topicOccurrence;
    }

    /**
     * @param array|TopicOccurrence[] $topicOccurrence
     * @return DescriptiveMetadata
     */
    public function setTopicOccurrence($topicOccurrence)
    {
        $this->topicOccurrence = $topicOccurrence;
        return $this;
    }

    /**
     * @return array|PropertyType[]
     */
    public function getProperty()
    {
        return $this->property;
    }

    /**
     * @param array|PropertyType[] $property
     * @return DescriptiveMetadata
     */
    public function setProperty($property)
    {
        $this->property = $property;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAssignedBy(): ?string
    {
        return $this->assignedBy;
    }

    /**
     * @param string|null $assignedBy
     * @return DescriptiveMetadata
     */
    public function setAssignedBy(?string $assignedBy): DescriptiveMetadata
    {
        $this->assignedBy = $assignedBy;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getImportance(): ?string
    {
        return $this->importance;
    }

    /**
     * @param string|null $importance
     * @return DescriptiveMetadata
     */
    public function setImportance(?string $importance): DescriptiveMetadata
    {
        $this->importance = $importance;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getConfidence(): ?string
    {
        return $this->confidence;
    }

    /**
     * @param string|null $confidence
     * @return DescriptiveMetadata
     */
    public function setConfidence(?string $confidence): DescriptiveMetadata
    {
        $this->confidence = $confidence;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getHowPresent(): ?string
    {
        return $this->howPresent;
    }

    /**
     * @param string|null $howPresent
     * @return DescriptiveMetadata
     */
    public function setHowPresent(?string $howPresent): DescriptiveMetadata
    {
        $this->howPresent = $howPresent;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDateAndTime(): ?string
    {
        return $this->dateAndTime;
    }

    /**
     * @param string|null $dateAndTime
     * @return DescriptiveMetadata
     */
    public function setDateAndTime(?string $dateAndTime): DescriptiveMetadata
    {
        $this->dateAndTime = $dateAndTime;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return DescriptiveMetadata
     */
    public function setDuid(?string $duid): DescriptiveMetadata
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return DescriptiveMetadata
     */
    public function setEuid(?string $euid): DescriptiveMetadata
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }

            $assignedByAttr = $node->attributes->getNamedItem('AssignedBy');
            if (!empty($assignedByAttr)) {
                $res->assignedBy = (string)$assignedByAttr->nodeValue;
            }

            $importanceAttr = $node->attributes->getNamedItem('Importance');
            if (!empty($importanceAttr)) {
                $res->importance = (string)$importanceAttr->nodeValue;
            }

            $confidenceAttr = $node->attributes->getNamedItem('Confidence');
            if (!empty($confidenceAttr)) {
                $res->confidence = (string)$confidenceAttr->nodeValue;
            }

            $howPresentAttr = $node->attributes->getNamedItem('HowPresent');
            if (!empty($howPresentAttr)) {
                $res->howPresent = (string)$howPresentAttr->nodeValue;
            }

            $dateAndTimeAttr = $node->attributes->getNamedItem('DateAndTime');
            if (!empty($dateAndTimeAttr)) {
                $res->dateAndTime = (string)$dateAndTimeAttr->nodeValue;
            }

        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Catalog':
                    $res->catalog = CatalogType::parse($curNode);
                    break;
                case 'Language':
                    $res->language[] = Language::parse($curNode);
                    break;
                case 'Genre':
                    $res->genre[] = Genre::parse($curNode);
                    break;
                case 'SubjectCode':
                    $res->subjectCode[] = SubjectCode::parse($curNode);
                    break;
                case 'OfInterestTo':
                    $res->ofInterestTo[] = OfInterestTo::parse($curNode);
                    break;
                case 'DateLineDate':
                    $res->dateLineDate[] = DateLineDate::parse($curNode);
                    break;
                case 'Location':
                    $res->location[] = Location::parse($curNode);
                    break;
                case 'TopicOccurrence':
                    $res->topicOccurrence[] = TopicOccurrence::parse($curNode);
                    break;
                case 'Property':
                    $res->property[] = PropertyType::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}