<?php


namespace Gek\AaApi\NewsML\NewsComponent;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "content" })
 * Class DataContent
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class DataContent
{

    #region fields

    /**
     * XmlMixed
     * XmlAnyElement(lax = true)
     * @var array
     */
    protected array $content = array();
    /**
     * XmlAttribute(name = "Duid")
     * XmlJavaTypeAdapter(CollapsedStringAdapter.class)
     * XmlID
     * XmlSchemaType(name = "ID")
     * @var string|null
     */
    protected ?string $duid = null;
    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array
     */
    public function getContent(): array
    {
        return $this->content;
    }

    /**
     * @param array $content
     * @return DataContent
     */
    public function setContent(array $content): DataContent
    {
        $this->content = $content;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return DataContent
     */
    public function setDuid(?string $duid): DataContent
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return DataContent
     */
    public function setEuid(?string $euid): DataContent
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }

        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);
            $res->content[] = (string)$curNode->nodeValue;
        }

        return $res;
    }

    #endregion statics

}