<?php


namespace Gek\AaApi\NewsML\NewsComponent;

use Gek\AaApi\NewsML\CommentType;
use Gek\AaApi\NewsML\ContributionType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "comment", "party", "contribution" })
 * Class Creator
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class Creator
{

    #region fields

    /**
     * XmlElement(name = "Comment")
     * @var array|CommentType[]
     */
    protected array $comment = array();
    /**
     * XmlElement(name = "Party", required = true)
     * @var array|Party[]
     */
    protected array $party = array();
    /**
     * XmlElement(name = "Contribution")
     * @var array
     */
    protected array $contribution = array();
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;
    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array|CommentType[]
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @param array|CommentType[] $comment
     * @return Creator
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return array
     */
    public function getParty(): array
    {
        return $this->party;
    }

    /**
     * @param array $party
     * @return Creator
     */
    public function setParty(array $party): Creator
    {
        $this->party = $party;
        return $this;
    }

    /**
     * @return array
     */
    public function getContribution(): array
    {
        return $this->contribution;
    }

    /**
     * @param array $contribution
     * @return Creator
     */
    public function setContribution(array $contribution): Creator
    {
        $this->contribution = $contribution;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Creator
     */
    public function setDuid(?string $duid): Creator
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Creator
     */
    public function setEuid(?string $euid): Creator
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Comment':
                    $res->comment[] = CommentType::parse($curNode);
                    break;
                case 'Party':
                    $res->party[] = Party::parse($curNode);
                    break;
                case 'Contribution':
                    $res->contribution[] = ContributionType::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}