<?php


namespace Gek\AaApi\NewsML\NewsComponent;

use Gek\AaApi\NewsML\CommentType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "comment", "copyrightHolder", "copyrightDate" })
 *
 * Class Copyright
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class Copyright
{

    #region fields

    /**
     * XmlElement(name = "Comment")
     *
     * @var array|CommentType[]
     */
    protected array $comment = array();

    /**
     * XmlElement(name = "CopyrightHolder", required = true)
     *
     * @var CopyrightHolder|null
     */
    protected ?CopyrightHolder $copyrightHolder = null;

    /**
     * XmlElement(name = "CopyrightDate", required = true)
     *
     * @var CopyrightDate|null
     */
    protected ?CopyrightDate $copyrightDate = null;

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     *
     * @var string|null
     */
    protected ?string $euid = null;

    /**
     * XmlAttribute(name = "AssignedBy")
     *
     * @var string|null
     */
    protected ?string $assignedBy = null;

    /**
     * XmlAttribute(name = "Importance")
     *
     * @var string|null
     */
    protected ?string $importance = null;

    /**
     * XmlAttribute(name = "Confidence")
     *
     * @var string|null
     */
    protected ?string $confidence = null;

    /**
     * XmlAttribute(name = "HowPresent")
     *
     * @var string|null
     */
    protected ?string $howPresent = null;

    /**
     * XmlAttribute(name = "DateAndTime")
     *
     * @var string|null
     */
    protected ?string $dateAndTime = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region Properties


    /**
     * @return array|CommentType[]
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @param array|CommentType[] $comment
     * @return Copyright
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return CopyrightHolder|null
     */
    public function getCopyrightHolder(): ?CopyrightHolder
    {
        return $this->copyrightHolder;
    }

    /**
     * @param CopyrightHolder|null $copyrightHolder
     * @return Copyright
     */
    public function setCopyrightHolder(?CopyrightHolder $copyrightHolder): Copyright
    {
        $this->copyrightHolder = $copyrightHolder;
        return $this;
    }

    /**
     * @return CopyrightDate|null
     */
    public function getCopyrightDate(): ?CopyrightDate
    {
        return $this->copyrightDate;
    }

    /**
     * @param CopyrightDate|null $copyrightDate
     * @return Copyright
     */
    public function setCopyrightDate(?CopyrightDate $copyrightDate): Copyright
    {
        $this->copyrightDate = $copyrightDate;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Copyright
     */
    public function setDuid(?string $duid): Copyright
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Copyright
     */
    public function setEuid(?string $euid): Copyright
    {
        $this->euid = $euid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAssignedBy(): ?string
    {
        return $this->assignedBy;
    }

    /**
     * @param string|null $assignedBy
     * @return Copyright
     */
    public function setAssignedBy(?string $assignedBy): Copyright
    {
        $this->assignedBy = $assignedBy;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getImportance(): ?string
    {
        return $this->importance;
    }

    /**
     * @param string|null $importance
     * @return Copyright
     */
    public function setImportance(?string $importance): Copyright
    {
        $this->importance = $importance;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getConfidence(): ?string
    {
        return $this->confidence;
    }

    /**
     * @param string|null $confidence
     * @return Copyright
     */
    public function setConfidence(?string $confidence): Copyright
    {
        $this->confidence = $confidence;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getHowPresent(): ?string
    {
        return $this->howPresent;
    }

    /**
     * @param string|null $howPresent
     * @return Copyright
     */
    public function setHowPresent(?string $howPresent): Copyright
    {
        $this->howPresent = $howPresent;
        return $this;
    }

    /**
     * @param string|null $dateAndTime
     * @return Copyright
     */
    public function setDateAndTime(?string $dateAndTime): Copyright
    {
        $this->dateAndTime = $dateAndTime;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDateAndTime(): ?string
    {
        return $this->dateAndTime;
    }

    #endregion Properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }

            $assignedByAttr = $node->attributes->getNamedItem('AssignedBy');
            if (!empty($assignedByAttr)) {
                $res->assignedBy = (string)$assignedByAttr->nodeValue;
            }

            $importanceAttr = $node->attributes->getNamedItem('Importance');
            if (!empty($importanceAttr)) {
                $res->importance = (string)$importanceAttr->nodeValue;
            }

            $confidenceAttr = $node->attributes->getNamedItem('Confidence');
            if (!empty($confidenceAttr)) {
                $res->confidence = (string)$confidenceAttr->nodeValue;
            }

            $howPresentAttr = $node->attributes->getNamedItem('HowPresent');
            if (!empty($howPresentAttr)) {
                $res->howPresent = (string)$howPresentAttr->nodeValue;
            }

            $dateAndTimeAttr = $node->attributes->getNamedItem('DateAndTime');
            if (!empty($dateAndTimeAttr)) {
                $res->dateAndTime = (string)$dateAndTimeAttr->nodeValue;
            }

        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Comment':
                    $res->comment[] = CommentType::parse($curNode);
                    break;
                case 'CopyrightHolder':
                    $res->copyrightHolder = CopyrightHolder::parse($curNode);
                    break;
                case 'CopyrightDate':
                    $res->copyrightDate = CopyrightDate::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}