<?php


namespace Gek\AaApi\NewsML\NewsComponent;

use Gek\AaApi\NewsML\Catalog\CatalogType;
use Gek\AaApi\NewsML\Catalog\Format;
use Gek\AaApi\NewsML\CommentType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "comment", "catalog", "mediaType", "format", "mimeType", "notation",
 * "characteristics", "encoding", "dataContent" })
 * Class ContentItem
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class ContentItem
{

    #region fields

    /**
     * XmlElement(name = "Comment")
     * @var array|CommentType[]
     */
    protected array $comment = array();

    /**
     * XmlElement(name = "Catalog")
     * @var CatalogType|null
     */
    protected ?CatalogType $catalog = null;

    /**
     * XmlElement(name = "MediaType")
     * @var MediaType|null
     */
    protected ?MediaType $mediaType = null;

    /**
     * XmlElement(name = "Format")
     * @var Format|null
     */
    protected ?Format $format = null;
    /**
     * XmlElement(name = "MimeType")
     * @var MimeType|null
     */
    protected ?MimeType $mimeType = null;

    /**
     * XmlElement(name = "Notation")
     * @var Notation|null
     */
    protected ?Notation $notation = null;

    /**
     * XmlElement(name = "Characteristics")
     * @var Characteristics|null
     */
    protected ?Characteristics $characteristics = null;

    /**
     * XmlElement(name = "Encoding")
     * @var Encoding|null
     */
    protected ?Encoding $encoding = null;

    /**
     * XmlElement(name = "DataContent")
     * @var DataContent|null
     */
    protected ?DataContent $dataContent = null;
    /**
     * XmlAttribute(name = "Href")
     * @var string|null
     */
    protected ?string $href = null;
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;
    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region properties

    /**
     * @return array|CommentType[]
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @param array|CommentType[] $comment
     * @return ContentItem
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return CatalogType|null
     */
    public function getCatalog(): ?CatalogType
    {
        return $this->catalog;
    }

    /**
     * @param CatalogType|null $catalog
     * @return ContentItem
     */
    public function setCatalog(?CatalogType $catalog): ContentItem
    {
        $this->catalog = $catalog;
        return $this;
    }

    /**
     * @return MediaType|null
     */
    public function getMediaType(): ?MediaType
    {
        return $this->mediaType;
    }

    /**
     * @param MediaType|null $mediaType
     * @return ContentItem
     */
    public function setMediaType(?MediaType $mediaType): ContentItem
    {
        $this->mediaType = $mediaType;
        return $this;
    }

    /**
     * @return Format|null
     */
    public function getFormat(): ?Format
    {
        return $this->format;
    }

    /**
     * @param Format|null $format
     * @return ContentItem
     */
    public function setFormat(?Format $format): ContentItem
    {
        $this->format = $format;
        return $this;
    }

    /**
     * @return MimeType|null
     */
    public function getMimeType(): ?MimeType
    {
        return $this->mimeType;
    }

    /**
     * @param MimeType|null $mimeType
     * @return ContentItem
     */
    public function setMimeType(?MimeType $mimeType): ContentItem
    {
        $this->mimeType = $mimeType;
        return $this;
    }

    /**
     * @return Notation|null
     */
    public function getNotation(): ?Notation
    {
        return $this->notation;
    }

    /**
     * @param Notation|null $notation
     * @return ContentItem
     */
    public function setNotation(?Notation $notation): ContentItem
    {
        $this->notation = $notation;
        return $this;
    }

    /**
     * @return Characteristics|null
     */
    public function getCharacteristics(): ?Characteristics
    {
        return $this->characteristics;
    }

    /**
     * @param Characteristics|null $characteristics
     * @return ContentItem
     */
    public function setCharacteristics(?Characteristics $characteristics): ContentItem
    {
        $this->characteristics = $characteristics;
        return $this;
    }

    /**
     * @return Encoding|null
     */
    public function getEncoding(): ?Encoding
    {
        return $this->encoding;
    }

    /**
     * @param Encoding|null $encoding
     * @return ContentItem
     */
    public function setEncoding(?Encoding $encoding): ContentItem
    {
        $this->encoding = $encoding;
        return $this;
    }

    /**
     * @return DataContent|null
     */
    public function getDataContent(): ?DataContent
    {
        return $this->dataContent;
    }

    /**
     * @param DataContent|null $dataContent
     * @return ContentItem
     */
    public function setDataContent(?DataContent $dataContent): ContentItem
    {
        $this->dataContent = $dataContent;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getHref(): ?string
    {
        return $this->href;
    }

    /**
     * @param string|null $href
     * @return ContentItem
     */
    public function setHref(?string $href): ContentItem
    {
        $this->href = $href;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return ContentItem
     */
    public function setDuid(?string $duid): ContentItem
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return ContentItem
     */
    public function setEuid(?string $euid): ContentItem
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
            $hrefAttr = $node->attributes->getNamedItem('Href');
            if (!empty($hrefAttr)) {
                $res->href = (string)$hrefAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Comment':
                    $res->comment[] = CommentType::parse($curNode);
                    break;
                case 'Catalog':
                    $res->catalog = CatalogType::parse($curNode);
                    break;
                case 'MediaType':
                    $res->mediaType = MediaType::parse($curNode);
                    break;
                case 'Format':
                    $res->format = Format::parse($curNode);
                    break;
                case 'MimeType':
                    $res->mimeType = MimeType::parse($curNode);
                    break;
                case 'Notation':
                    $res->notation = Notation::parse($curNode);
                    break;
                case 'Characteristics':
                    $res->characteristics = Characteristics::parse($curNode);
                    break;
                case 'Encoding':
                    $res->encoding = Encoding::parse($curNode);
                    break;
                case 'DataContent':
                    $res->dataContent = DataContent::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}