<?php


namespace Gek\AaApi\NewsML\NewsComponent;

use Gek\AaApi\NewsML\PropertyType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "sizeInBytes", "property" })
 * Class Characteristics
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class Characteristics
{

    #region fields


    /**
     * XmlElement(name = "SizeInBytes")
     * @var SizeInBytes|null
     */
    protected ?SizeInBytes $sizeInBytes = null;

    /**
     * XmlElement(name = "Property")
     * @var array|PropertyType[]
     */
    protected array $property = array();

    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return SizeInBytes|null
     */
    public function getSizeInBytes(): ?SizeInBytes
    {
        return $this->sizeInBytes;
    }

    /**
     * @param SizeInBytes|null $sizeInBytes
     * @return Characteristics
     */
    public function setSizeInBytes(?SizeInBytes $sizeInBytes): Characteristics
    {
        $this->sizeInBytes = $sizeInBytes;
        return $this;
    }

    /**
     * @return array|PropertyType[]
     */
    public function getProperty()
    {
        return $this->property;
    }

    /**
     * @param array|PropertyType[] $property
     * @return Characteristics
     */
    public function setProperty($property)
    {
        $this->property = $property;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Characteristics
     */
    public function setDuid(?string $duid): Characteristics
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Characteristics
     */
    public function setEuid(?string $euid): Characteristics
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'SizeInBytes':
                    $res->sizeInBytes = SizeInBytes::parse($curNode);
                    break;
                case 'Property':
                    $res->property[] = PropertyType::parse($curNode);
                    break;
            }
        }

        return $res;
    }

    #endregion statics

}