<?php


namespace Gek\AaApi\NewsML\NewsComponent;

use Gek\AaApi\NewsML\Catalog\CatalogType;
use Gek\AaApi\NewsML\ContributionType;
use Gek\AaApi\NewsML\PropertyType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "catalog", "fileName", "systemIdentifier", "provider", "creator", "source",
 * "contributor", "property" })
 * @ToString
 * Class AdministrativeMetadata
 * @package Gek\AaApi\NewsML\NewsComponent
 */
class AdministrativeMetadata
{

    #region fields


    /**
     * XmlElement(name = "Catalog")
     * @var CatalogType|null
     */
    protected ?CatalogType $catalog = null;
    /**
     * XmlElement(name = "FileName")
     * @var FileName|null
     */
    protected ?FileName $fileName = null;
    /**
     * XmlElement(name = "SystemIdentifier")
     * @var SystemIdentifier|null
     */
    protected ?SystemIdentifier $systemIdentifier = null;

    /**
     * XmlElement(name = "Provider")
     * @var Provider|null
     */
    protected ?Provider $provider = null;

    /**
     * XmlElement(name = "Creator")
     * @var array|Creator[]
     */
    protected array $creator = array();

    /**
     * XmlElement(name = "Source")
     * @var array|Source[]
     */
    protected array $source = array();
    /**
     * XmlElement(name = "Contributor")
     * @var array|Contributor[]
     */
    protected array $contributor = array();

    /**
     * XmlElement(name = "Property")
     * @var array|PropertyType[]
     */
    protected array $property = array();
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return CatalogType|null
     */
    public function getCatalog(): ?CatalogType
    {
        return $this->catalog;
    }

    /**
     * @param CatalogType|null $catalog
     * @return AdministrativeMetadata
     */
    public function setCatalog(?CatalogType $catalog): AdministrativeMetadata
    {
        $this->catalog = $catalog;
        return $this;
    }

    /**
     * @return FileName|null
     */
    public function getFileName(): ?FileName
    {
        return $this->fileName;
    }

    /**
     * @param FileName|null $fileName
     * @return AdministrativeMetadata
     */
    public function setFileName(?FileName $fileName): AdministrativeMetadata
    {
        $this->fileName = $fileName;
        return $this;
    }

    /**
     * @return SystemIdentifier|null
     */
    public function getSystemIdentifier(): ?SystemIdentifier
    {
        return $this->systemIdentifier;
    }

    /**
     * @param SystemIdentifier|null $systemIdentifier
     * @return AdministrativeMetadata
     */
    public function setSystemIdentifier(?SystemIdentifier $systemIdentifier): AdministrativeMetadata
    {
        $this->systemIdentifier = $systemIdentifier;
        return $this;
    }

    /**
     * @return Provider|null
     */
    public function getProvider(): ?Provider
    {
        return $this->provider;
    }

    /**
     * @param Provider|null $provider
     * @return AdministrativeMetadata
     */
    public function setProvider(?Provider $provider): AdministrativeMetadata
    {
        $this->provider = $provider;
        return $this;
    }

    /**
     * @return array|Creator[]
     */
    public function getCreator()
    {
        return $this->creator;
    }

    /**
     * @param array|Creator[] $creator
     * @return AdministrativeMetadata
     */
    public function setCreator($creator)
    {
        $this->creator = $creator;
        return $this;
    }

    /**
     * @return array|Source[]
     */
    public function getSource()
    {
        return $this->source;
    }

    /**
     * @param array|Source[] $source
     * @return AdministrativeMetadata
     */
    public function setSource($source)
    {
        $this->source = $source;
        return $this;
    }

    /**
     * @return array|Contributor[]
     */
    public function getContributor()
    {
        return $this->contributor;
    }

    /**
     * @param array|Contributor[] $contributor
     * @return AdministrativeMetadata
     */
    public function setContributor($contributor)
    {
        $this->contributor = $contributor;
        return $this;
    }

    /**
     * @return array|PropertyType[]
     */
    public function getProperty()
    {
        return $this->property;
    }

    /**
     * @param array|PropertyType[] $property
     * @return AdministrativeMetadata
     */
    public function setProperty($property)
    {
        $this->property = $property;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return AdministrativeMetadata
     */
    public function setDuid(?string $duid): AdministrativeMetadata
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return AdministrativeMetadata
     */
    public function setEuid(?string $euid): AdministrativeMetadata
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Catalog':
                    $res->catalog = CatalogType::parse($curNode);
                    break;
                case 'FileName':
                    $res->fileName = FileName::parse($curNode);
                    break;
                case 'SystemIdentifier':
                    $res->systemIdentifier = SystemIdentifier::parse($curNode);
                    break;
                case 'Provider':
                    $res->provider = Provider::parse($curNode);
                    break;
                case 'Creator':
                    $res->creator[] = Creator::parse($curNode);
                    break;
                case 'Source':
                    $res->source[] = Source::parse($curNode);
                    break;
                case 'Contributor':
                    $res->contributor[] = Contributor::parse($curNode);
                    break;
                case 'Property':
                    $res->property[] = PropertyType::parse($curNode);
                    break;

            }

        }

        return $res;
    }

    #endregion statics

}