<?php


namespace Gek\AaApi\NewsML;

/**
 * XmlType(name = "DateAndTimeType", propOrder = { "value" })
 *
 * Class DateAndTimeType
 * @package Gek\AaApi\NewsML
 */
class DateAndTimeType
{
    #region fields

    /**
     * XmlValue
     *
     * @var string|null
     */
    protected ?string $value = null;

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     *
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct(?string $value = null)
    {
        $this->value = $value;
    }

    #endregion ctor

    #region properties

    /**
     * @return string|null
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * @param string|null $value
     * @return DateAndTimeType
     */
    public function setValue(?string $value): DateAndTimeType
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return DateAndTimeType
     */
    public function setDuid(?string $duid): DateAndTimeType
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return DateAndTimeType
     */
    public function setEuid(?string $euid): DateAndTimeType
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node):self {
        $res = new self();

        $res->value = (string)$node->nodeValue;

        if ($node->hasAttributes()) {


            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        return $res;
    }

    #endregion statics

}