<?php


namespace Gek\AaApi\NewsML;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "CommentType", propOrder = { "value" })
 *
 * Class CommentType
 * @package Gek\AaApi\NewsML
 */
class CommentType
{

    #region fields

    /**
     * XmlValue
     *
     * @var string|null
     */
    protected ?string $value = null;

    /**
     * XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
     *
     * @var string|null
     */
    protected ?string $lang = null;


    /**
     * XmlAttribute(name = "TranslationOf")
     *
     * @var mixed|null
     */
    protected $translationOf = null;

    /**
     * XmlAttribute(name = "FormalName")
     *
     * @var string|null
     */
    protected ?string $formalName = null;

    /**
     * XmlAttribute(name = "Vocabulary")
     *
     * @var string|null
     */
    protected ?string $vocabulary = null;

    /**
     * XmlAttribute(name = "Scheme")
     *
     * @var string|null
     */
    protected ?string $scheme = null;

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $euid = null;


    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return string|null
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * @param string|null $value
     * @return CommentType
     */
    public function setValue(?string $value): CommentType
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getLang(): ?string
    {
        return $this->lang;
    }

    /**
     * @param string|null $lang
     * @return CommentType
     */
    public function setLang(?string $lang): CommentType
    {
        $this->lang = $lang;
        return $this;
    }

    /**
     * @return mixed|null
     */
    public function getTranslationOf()
    {
        return $this->translationOf;
    }

    /**
     * @param mixed|null $translationOf
     * @return CommentType
     */
    public function setTranslationOf( $translationOf): CommentType
    {
        $this->translationOf = $translationOf;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFormalName(): ?string
    {
        return $this->formalName;
    }

    /**
     * @param string|null $formalName
     * @return CommentType
     */
    public function setFormalName(?string $formalName): CommentType
    {
        $this->formalName = $formalName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getVocabulary(): ?string
    {
        return $this->vocabulary;
    }

    /**
     * @param string|null $vocabulary
     * @return CommentType
     */
    public function setVocabulary(?string $vocabulary): CommentType
    {
        $this->vocabulary = $vocabulary;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getScheme(): ?string
    {
        return $this->scheme;
    }

    /**
     * @param string|null $scheme
     * @return CommentType
     */
    public function setScheme(?string $scheme): CommentType
    {
        $this->scheme = $scheme;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return CommentType
     */
    public function setDuid(?string $duid): CommentType
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return CommentType
     */
    public function setEuid(?string $euid): CommentType
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node):self {
        $res = new self();
        $res->value = (string)$node->nodeValue;

        if ($node->hasAttributes()) {


            $langAttr = $node->attributes->getNamedItem('lang');
            if (!empty($langAttr)) {
                $res->lang = (string)$langAttr->nodeValue;
            }

            $translationOfAttr = $node->attributes->getNamedItem('TranslationOf');
            if (!empty($translationOfAttr)) {
                $res->translationOf = (string)$translationOfAttr->nodeValue;
            }

            $formalNameAttr = $node->attributes->getNamedItem('FormalName');
            if (!empty($formalNameAttr)) {
                $res->formalName = (string)$formalNameAttr->nodeValue;
            }

            $vocabularyAttr = $node->attributes->getNamedItem('Vocabulary');
            if (!empty($vocabularyAttr)) {
                $res->vocabulary = (string)$vocabularyAttr->nodeValue;
            }

            $schemeAttr = $node->attributes->getNamedItem('Scheme');
            if (!empty($schemeAttr)) {
                $res->scheme = (string)$schemeAttr->nodeValue;
            }

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }



        return $res;
    }

    #endregion statics

}