<?php


namespace Gek\AaApi\NewsML\Catalog;


class Url
{

    #region fields

    /**
     * XmlValue
     *
     * @var string
     */
    protected string $value;

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     *
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct(string $value = "", ?string $duid = null, ?string $euid = null )
    {
        $this->value = $value;
        $this->duid = $duid;
        $this->euid = $euid;
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }

    /**
     * @param string $value
     * @return Url
     */
    public function setValue(string $value): Url
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Url
     */
    public function setDuid(?string $duid): Url
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Url
     */
    public function setEuid(?string $euid): Url
    {
        $this->euid = $euid;
        return $this;
    }


    #endregion properties

    #region statics

    public static function parse(\DOMNode $node):self {
        $res = new self();

        $res->value = (string)$node->nodeValue;

        if ($node->hasAttributes()) {

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }


        return $res;
    }

    #endregion statics

}