<?php


namespace Gek\AaApi\NewsML\Catalog;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "")
 * Class TopicUse
 * @package Gek\AaApi\NewsML\Catalog
 */
class TopicUse
{
    #region fields

    /**
     * XmlAttribute(name = "Topic", required = true)
     * @var string
     */
    protected string $topic;

    /**
     * XmlAttribute(name = "Context")
     * @var string|null
     */
    protected ?string $context = null;

    #endregion fields

    #region ctor

    public function __construct(string $topic = "", ?string $context = null)
    {
        $this->topic = $topic;
        $this->context = $context;
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getTopic(): string
    {
        return $this->topic;
    }

    /**
     * @param string $topic
     * @return TopicUse
     */
    public function setTopic(string $topic): TopicUse
    {
        $this->topic = $topic;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getContext(): ?string
    {
        return $this->context;
    }

    /**
     * @param string|null $context
     * @return TopicUse
     */
    public function setContext(?string $context): TopicUse
    {
        $this->context = $context;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node):self {
        $res = new self();

        if ($node->hasAttributes()) {

            $topicAttr = $node->attributes->getNamedItem('Topic');
            if (!empty($topicAttr)) {
                $res->topic = (string)$topicAttr->nodeValue;
            }

            $contextAttr = $node->attributes->getNamedItem('Context');
            if (!empty($contextAttr)) {
                $res->context = (string)$contextAttr->nodeValue;
            }
        }

        return $res;
    }

    #endregion statics

}