<?php


namespace Gek\AaApi\NewsML\Catalog;


class Resource
{

    #region fields

    /**
     * XmlElement(name = "Urn")
     *
     * @var Urn|null
     */
    protected ?Urn $urn = null;

    /**
     * XmlElement(name = "Url")
     *
     * @var array|Url[]
     */
    protected array $url = array();

    /**
     * XmlElement(name = "DefaultVocabularyFor")
     *
     * @var array|DefaultVocabularyFor[]
     */
    protected array $defaultVocabularyFor = array();

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     *
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return Urn|null
     */
    public function getUrn(): ?Urn
    {
        return $this->urn;
    }

    /**
     * @param Urn|null $urn
     * @return Resource
     */
    public function setUrn(?Urn $urn): Resource
    {
        $this->urn = $urn;
        return $this;
    }

    /**
     * @return array|Url[]
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param array|Url[] $url
     * @return Resource
     */
    public function setUrl($url)
    {
        $this->url = $url;
        return $this;
    }

    /**
     * @return array|DefaultVocabularyFor[]
     */
    public function getDefaultVocabularyFor()
    {
        return $this->defaultVocabularyFor;
    }

    /**
     * @param array|DefaultVocabularyFor[] $defaultVocabularyFor
     * @return Resource
     */
    public function setDefaultVocabularyFor($defaultVocabularyFor)
    {
        $this->defaultVocabularyFor = $defaultVocabularyFor;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Resource
     */
    public function setDuid(?string $duid): Resource
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Resource
     */
    public function setEuid(?string $euid): Resource
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node):self {
        $res = new self();

        if ($node->hasAttributes()) {

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Urn':
                    $res->urn = Urn::parse($curNode);
                    break;
                case 'Url':
                    $res->url[] = Url::parse($curNode);
                    break;
                case 'DefaultVocabularyFor':
                    $res->defaultVocabularyFor[] = DefaultVocabularyFor::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}