<?php


namespace Gek\AaApi\NewsML\Catalog;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "")
 * Class Format
 * @package Gek\AaApi\NewsML\Catalog
 */
class Format
{

    #region fields
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;
    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    /**
     * XmlAttribute(name = "FormalName", required = true)
     * @var string
     */
    protected string $formalName;

    /**
     * XmlAttribute(name = "Vocabulary")
     * @var string|null
     */
    protected ?string $vocabulary = null;

    /**
     * XmlAttribute(name = "Scheme")
     * @var string|null
     */
    protected ?string $scheme = null;

    #endregion fields

    #region ctor

    public function __construct(string $formalName = "")
    {
        $this->formalName = $formalName;
    }

    #endregion ctor

    #region properties

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Format
     */
    public function setDuid(?string $duid): Format
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Format
     */
    public function setEuid(?string $euid): Format
    {
        $this->euid = $euid;
        return $this;
    }

    /**
     * @return string
     */
    public function getFormalName(): string
    {
        return $this->formalName;
    }

    /**
     * @param string $formalName
     * @return Format
     */
    public function setFormalName(string $formalName): Format
    {
        $this->formalName = $formalName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getVocabulary(): ?string
    {
        return $this->vocabulary;
    }

    /**
     * @param string|null $vocabulary
     * @return Format
     */
    public function setVocabulary(?string $vocabulary): Format
    {
        $this->vocabulary = $vocabulary;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getScheme(): ?string
    {
        return $this->scheme;
    }

    /**
     * @param string|null $scheme
     * @return Format
     */
    public function setScheme(?string $scheme): Format
    {
        $this->scheme = $scheme;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
            $schemeAttr = $node->attributes->getNamedItem('Scheme');
            if (!empty($schemeAttr)) {
                $res->scheme = (string)$schemeAttr->nodeValue;
            }

            $VocabularyAttr = $node->attributes->getNamedItem('Vocabulary');
            if (!empty($VocabularyAttr)) {
                $res->vocabulary = (string)$VocabularyAttr->nodeValue;
            }

            $FormalNameAttr = $node->attributes->getNamedItem('FormalName');
            if (!empty($FormalNameAttr)) {
                $res->formalName = (string)$FormalNameAttr->nodeValue;
            }
        }

        return $res;
    }

    #endregion statics

}