<?php


namespace Gek\AaApi\NewsML\Catalog;


class DefaultVocabularyFor
{

    #region fields

    /**
     * XmlAttribute(name = "Context", required = true)
     *
     * @var string
     */
    protected string $context;

    /**
     * XmlAttribute(name = "Scheme")
     *
     * @var string|null
     */
    protected ?string $scheme = null;

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * @var string|null
     */
    public ?string $euid = null;

    #endregion fields

    #region ctor

    /**
     * DefaultVocabularyFor constructor.
     * @param string $context
     * @param string|null $scheme
     * @param string|null $duid
     * @param string|null $euid
     */
    public function __construct(string $context = "", ?string $scheme = null, ?string $duid = null, ?string $euid = null)
    {
        $this->context = $context;
        $this->scheme = $scheme;
        $this->duid = $duid;
        $this->euid = $euid;
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getContext(): string
    {
        return $this->context;
    }

    /**
     * @param string $context
     * @return DefaultVocabularyFor
     */
    public function setContext(string $context): DefaultVocabularyFor
    {
        $this->context = $context;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getScheme(): ?string
    {
        return $this->scheme;
    }

    /**
     * @param string|null $scheme
     * @return DefaultVocabularyFor
     */
    public function setScheme(?string $scheme): DefaultVocabularyFor
    {
        $this->scheme = $scheme;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return DefaultVocabularyFor
     */
    public function setDuid(?string $duid): DefaultVocabularyFor
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return DefaultVocabularyFor
     */
    public function setEuid(?string $euid): DefaultVocabularyFor
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {

            $contextAttr = $node->attributes->getNamedItem('Context');
            if (!empty($contextAttr)) {
                $res->context = (string)$contextAttr->nodeValue;
            }

            $schemeAttr = $node->attributes->getNamedItem('Scheme');
            if (!empty($schemeAttr)) {
                $res->scheme = (string)$schemeAttr->nodeValue;
            }

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }


        return $res;
    }

    #endregion statics

}