<?php


namespace Gek\AaApi\NewsML\Catalog;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "CatalogType", propOrder = { "resource", "topicUse" })
 *
 *
 * Class CatalogType
 * @package Gek\AaApi\NewsML\Catalog
 */
class CatalogType
{

    #region fields

    /**
     * XmlElement(name = "Resource")
     *
     * @var array|Resource[]
     */
    protected array $resource = array();

    /**
     * XmlElement(name = "TopicUse")
     *
     * @var array|TopicUse[]
     */
    protected array $topicUse = array();

    /**
     * XmlAttribute(name = "Href")
     *
     * @var string|null
     */
    protected ?string $href = null;

    /**
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     *
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array|Resource[]
     */
    public function getResource()
    {
        return $this->resource;
    }

    /**
     * @param array|Resource[] $resource
     * @return CatalogType
     */
    public function setResource($resource)
    {
        $this->resource = $resource;
        return $this;
    }

    /**
     * @return array|TopicUse[]
     */
    public function getTopicUse()
    {
        return $this->topicUse;
    }

    /**
     * @param array|TopicUse[] $topicUse
     * @return CatalogType
     */
    public function setTopicUse($topicUse)
    {
        $this->topicUse = $topicUse;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getHref(): ?string
    {
        return $this->href;
    }

    /**
     * @param string|null $href
     * @return CatalogType
     */
    public function setHref(?string $href): CatalogType
    {
        $this->href = $href;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return CatalogType
     */
    public function setDuid(?string $duid): CatalogType
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return CatalogType
     */
    public function setEuid(?string $euid): CatalogType
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node):self {
        $res = new self();

        if ($node->hasAttributes()) {
            $hrefAttr = $node->attributes->getNamedItem('Href');
            if (!empty($hrefAttr)) {
                $res->href = (string)$hrefAttr->nodeValue;
            }

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);




            switch ($curNode->nodeName) {
                case 'Resource':
                    $res->resource[] = Resource::parse($curNode);
                    break;
                case 'TopicUse':
                    $res->topicUse[] = TopicUse::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}