<?php


namespace Gek\AaApi;


class Discover
{

    /**
     * category
     *
     * category: Haberin kategorisi ifade eder. (1:Genel, 2:Spor, 3:Ekonomi, 4:Sağlık, 5:Bilim-Teknoloji,
     * 6:Politika, 7:Kültür-Sanat-Yaşam)
     *
     * @var array
     *
     */
    public $category = array();

    /**
     * @param array $searchTerms
     * @return array
     */
    public function searchCategory(array $searchTerms):array{
        $res = array();
        foreach ($this->category as $key => $val){
            $cVal = mb_strtolower($val,'UTF-8');
            foreach ($searchTerms as $term){
                $sTrm = mb_strtolower($term,'UTF-8');
                if(false !== mb_strpos($cVal,$sTrm)){
                    $res[] = $key;
                }
            }
        }
        return $res;
    }


    /**
     * priorty
     *
     * priorty: Haberin önceliğini ifade eder. (1:Flaş, 2:Acil, 3:Önemli, 4:Rutin, 5:Özel, 6:Arşiv)
     *
     * @var array
     */
    public $priority = array();

    /**
     * @param array $searchTerms
     * @return array
     */
    public function searchPriority(array $searchTerms):array{
        $res = array();
        foreach ($this->priority as $key => $val){
            $cVal = mb_strtolower($val,'UTF-8');
            foreach ($searchTerms as $term){
                $sTrm = mb_strtolower($term,'UTF-8');
                if(false !== mb_strpos($cVal,$sTrm)){
                    $res[] = $key;
                }
            }
        }
        return $res;
    }

    /**
     * package
     *
     * package: Haberin yayınlandığı, abone olduğunuz haber bültenlerini ifade eder. (1:Genel Bülten,
     * 2:Özel Bülten, 3:Yerel Bülten, 5:İnternet Haber Bülteni vb.
     *
     * @var array
     */
    public $package = array();

    /**
     * @param array $searchTerms
     * @return array
     */
    public function searchPackage(array $searchTerms):array{
        $res = array();
        foreach ($this->package as $key => $val){
            $cVal = mb_strtolower($val,'UTF-8');
            foreach ($searchTerms as $term){
                $sTrm = mb_strtolower($term,'UTF-8');
                if(false !== mb_strpos($cVal,$sTrm)){
                    $res[] = $key;
                }
            }
        }
        return $res;
    }


    /**
     * type
     *
     * type: Haberin türünü ifade eder. (1:Haber, 2:Fotoğraf, 3:Video, 4:Dosya, 5:Grafik)
     *
     * @var array
     */
    public $type = array();

    /**
     * @param array $searchTerms
     * @return array
     */
    public function searchType(array $searchTerms):array{
        $res = array();
        foreach ($this->type as $key => $val){
            $cVal = mb_strtolower($val,'UTF-8');
            foreach ($searchTerms as $term){
                $sTrm = mb_strtolower($term,'UTF-8');
                if(false !== mb_strpos($cVal,$sTrm)){
                    $res[] = $key;
                }
            }
        }
        return $res;
    }

    /**
     * language
     *
     * language: Seçilen bülten içinden servis edilen diller arasından hangisini istediğinizi ifade eder.
     * (Örneğin; Genel Bültenden Türkçe Olarak Servis edilen haberler)
     * 1:tr_TR : Türkçe
     * 2:en_US : İngilizce
     * 3:ar_SA : Arapça
     *
     * @var array
     */
    public $language = array();

    /**
     * @param array $searchTerms
     * @return array
     */
    public function searchLanguage(array $searchTerms):array{
        $res = array();
        foreach ($this->language as $key => $val){
            $cVal = mb_strtolower($val,'UTF-8');
            foreach ($searchTerms as $term){
                $sTrm = mb_strtolower($term,'UTF-8');
                if(false !== mb_strpos($cVal,$sTrm)){
                    $res[] = $key;
                }
            }
        }
        return $res;
    }

    /**
     * provider
     *
     * provider: Haberin kaynağını/sağlayıcısını ifade eder. Örnek veride bulunan “1”: “Anadolu Ajansı”
     * kısmı search işleminde filter_provider için kullanabileceğiniz sayısal veriyi belirtir.
     *
     * @var array
     */
    public $provider = array();

    /**
     * @param array $searchTerms
     * @return array
     */
    public function searchProvider(array $searchTerms):array{
        $res = array();
        foreach ($this->provider as $key => $val){
            $cVal = mb_strtolower($val,'UTF-8');
            foreach ($searchTerms as $term){
                $sTrm = mb_strtolower($term,'UTF-8');
                if(false !== mb_strpos($cVal,$sTrm)){
                    $res[] = $key;
                }
            }
        }
        return $res;
    }

    /**
     * @param object $obj
     * @return Discover
     */
    public static function fromObject($obj){
        $res = new self();

        if(isset($obj->category) && (is_object($obj->category) || is_array($obj->category))){
            foreach ($obj->category as $key => $val){
                $res->category[$key] = $val;
            }
        }

        if(isset($obj->priority) && (is_object($obj->priority) || is_array($obj->priority))){
            foreach ($obj->priority as $key => $val){
                $res->priority[$key] = $val;
            }
        }

        if(isset($obj->package) && (is_object($obj->package) || is_array($obj->package))){
            foreach ($obj->package as $key => $val){
                $res->package[$key] = $val;
            }
        }

        if(isset($obj->type) && (is_object($obj->type) || is_array($obj->type))){
            foreach ($obj->type as $key => $val){
                $res->type[$key] = $val;
            }
        }

        if(isset($obj->language) && (is_object($obj->language) || is_array($obj->language))){
            foreach ($obj->language as $key => $val){
                $res->language[$key] = $val;
            }
        }

        if(isset($obj->provider) && (is_object($obj->provider) || is_array($obj->provider))){
            foreach ($obj->provider as $key => $val){
                $res->provider[$key] = $val;
            }
        }
        return $res;
    }

}