<?php


namespace Gek\AaApi;


class AaClient
{

    #region fields

    protected static $lastRequestTime;

    const LIMIT_MICROTIME = 500;

    /**
     * @var string
     */
    protected $apiUrl = 'https://api.aa.com.tr/';

    /**
     * @var string
     */
    protected $username = 'aaapi_cln_usr_1584z';

    /**
     * @var string
     */
    protected $password = 'pUJ45@trYj|4oq!LSz2';

    /** @var array|null  */
    protected $lastResponse = null;

    #endregion fields

    #region ctor

    public function __construct($options = array())
    {
        if (array_key_exists('apiUrl', $options)) {
            $this->setApiUrl($options['apiUrl']);
        }
        if (array_key_exists('username', $options)) {
            $this->setUsername($options['username']);
        }
        if (array_key_exists('password', $options)) {
            $this->setPassword($options['password']);
        }
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getApiUrl($part = '')
    {
        $url = $this->apiUrl;
        if (!empty($part)) {
            $part = trim($part);
            $url .= ltrim($part, "/\\");
        }
        return $url;
    }

    /**
     * @param string $apiUrl
     * @return AaClient
     */
    public function setApiUrl($apiUrl)
    {
        if (!empty($apiUrl)) {
            $apiUrl = trim($apiUrl, " \t\n\r\0\x0B/\\") . '/';
        }
        $this->apiUrl = $apiUrl;
        return $this;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     * @return AaClient
     */
    public function setUsername($username)
    {
        $this->username = $username;
        return $this;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @param string $password
     * @return AaClient
     */
    public function setPassword($password)
    {
        $this->password = $password;
        return $this;
    }

    #endregion properties

    #region methods

    public function test()
    {

        self::checkRequestTime();
        echo "işlem tamam \n";
    }

    /**
     * @param string $language
     * @return Discover
     * @throws \Exception
     */
    public function discover($language = 'tr_TR'){
        $path = '/abone/discover/' . $language;

        $res = $this->request($path,'GET');
        $res = json_decode($res);
        $response = ApiResponse::fromObject($res->response);
        if(!$response->success){
            throw new \Exception('İstek başarısız oldu. Dönen kod: ' . $response->code);
        }


        return Discover::fromObject($res->data);
    }

    /**
     * @return SubscriptionResult
     * @throws \Exception
     */
    public function subscription(){
        $path = '/abone/subscription';

        $res = $this->request($path,'GET');
        $res = json_decode($res);
        $response = ApiResponse::fromObject($res->response);
        if(!$response->success){
            throw new \Exception('İstek başarısız oldu. Dönen kod: ' . $response->code);
        }
        return SubscriptionResult::fromObject($res->data);
    }

    public function document(string $id, ?string $size = null){
        //GET /abone/document/
        $path = '/abone/document/'.$id;
        if(empty($size)){
            if(false !== strpos($id,'text')){
                $size = 'newsml12';
            }elseif (false !== strpos($id,'picture')){
                $size = 'web';
            }elseif (false !== strpos($id,'video')){
                $size = 'web';
            }
        }
        $path .= '/' . $size;

        $res = $this->request($path,'GET');
        $obj = json_decode($res);

        if(json_last_error() === JSON_ERROR_NONE){
            $response = ApiResponse::fromObject($obj->response);
            if(!$response->success){

                $errMesaj = 'İstek başarısız oldu. Dönen kod: ' . $response->code;
                if(!empty($response->message)){
                    $errMesaj .= ' Mesaj: ' . $response->message;
                }
                throw new \Exception($errMesaj);
            }
        }

        return $res;
    }

    public function token(string $id, ?string $size = null){
        //GET /abone/token/
        $path = '/abone/token/'.$id;
        if(empty($size)){
            if(false !== strpos($id,'text')){
                $size = 'newsml12';
            }elseif (false !== strpos($id,'picture')){
                $size = 'web';
            }elseif (false !== strpos($id,'video')){
                $size = 'web';
            }
        }
        $path .= '/' . $size;

        $res = $this->request($path,'GET');
        $obj = json_decode($res);

        if(json_last_error() === JSON_ERROR_NONE){
            $response = ApiResponse::fromObject($obj->response);
            if(!$response->success){

                $errMesaj = 'İstek başarısız oldu. Dönen kod: ' . $response->code;
                if(!empty($response->message)){
                    $errMesaj .= ' Mesaj: ' . $response->message;
                }
                throw new \Exception($errMesaj);
            }
        }
        if(empty($res)){
            if(in_array($this->lastResponse['http_code'],['302','301'])){
                if(isset($this->lastResponse['header']['Location'])){
                    $url = $this->lastResponse['header']['Location'];
                    return $url;
                }
            }
        }
        return $res;
    }

    /**
     * @param SearchQuery $query
     * @return SearchResult
     * @throws \Exception
     */
    public function search(SearchQuery $query){
        $path = '/abone/search';
        $res = $this->request($path,'POST',$query->toObject());
        $res = json_decode($res);
        $response = ApiResponse::fromObject($res->response);
        if(!$response->success){
            throw new \Exception('İstek başarısız oldu. Dönen kod: ' . $response->code);
        }

        return SearchResult::fromObject($res->data);
    }



    #endregion methods

    #region utils

    /**
     * @param string $path
     * @param string $method
     * @param string|object|array|null $data
     * @param bool $isJson
     * @return bool|string
     * @throws \Exception
     */
    protected function request($path, $method = 'GET', $data = null, $isJson = false)
    {
        self::checkRequestTime();
        $url = $this->getApiUrl($path);

        $method = strtoupper($method);

        if (!empty($data)) {
            switch ($method) {
                case 'GET':
                case 'HEAD':
                case 'DELETE':
                case 'CONNECT':
                case 'OPTIONS':
                case 'TRACE':
                    $str = '?';
                    if (is_string($data)) {
                        $str .= ltrim($data, '?');
                    } else {
                        foreach ($data as $key => $val) {
                            $str .= $key . "=";
                            if (is_object($val)) {
                                if (method_exists($val, '__toString')) {
                                    $str .= urlencode($val->__toString());
                                } else {
                                    $str .= urlencode(json_encode($val));
                                }
                            } elseif (is_array($val)) {
                                $str .= urlencode(json_encode($val));
                            } else {
                                $str .= urlencode($val . '');
                            }
                            $str .= '&';
                        }
                    }
                    $str = rtrim($str, '&');
                    $url .= $str;
                    $ch = curl_init($url);
                    break;
                case 'POST':
                case 'PUT':
                case 'PATCH':
                $ch = curl_init($url);
                if($isJson){
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
                }else{
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                }

                break;
            }
        }else{
            $ch = curl_init($url);
        }

        if ($method !== 'GET') {
            switch ($method) {
                case 'POST;':
                    curl_setopt($ch, CURLOPT_POST, true);
                    break;
                case 'PUT':
                    curl_setopt($ch, CURLOPT_PUT, true);
                    break;
                case 'DELETE':
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
                    break;
                case 'CONNECT':
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'CONNECT');
                    break;
                case 'OPTIONS':
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'OPTIONS');
                    break;
                case 'PATCH':
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PATCH');
                    break;
                case 'TRACE':
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'TRACE');
                    break;
                case 'HEAD':
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'HEAD');
                    break;
            }
        }

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        //curl_setopt($ch,CURLOPT_FOLLOWLOCATION,TRUE);
        curl_setopt($ch, CURLOPT_USERPWD, $this->getUsername() . ":" . $this->getPassword());
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_VERBOSE, true);
        curl_setopt($ch, CURLOPT_HEADER, true);
        $response = curl_exec($ch);
        $this->lastResponse = array();
        if (curl_errno($ch)) {
            $err = curl_error($ch);
            $this->lastResponse['curl_error'] = $err;
            throw new \Exception($err);
        }
        $header_size = curl_getinfo($ch,CURLINFO_HEADER_SIZE);
        $this->lastResponse['header'] = substr($response, 0, $header_size);
        if(!empty($this->lastResponse['header'])){
            $header = $this->lastResponse['header'];
            $arr = explode(PHP_EOL,$header);
            $hres = array();
            foreach ($arr as $h){
                if(empty($h)){
                    continue;
                }
                $pos = strpos($h,':');
                if(false === $pos){
                    $hres['http'] = $h;
                }else{
                    $key = substr($h,0,$pos);
                    $value = substr($h,$pos + 1);
                    $hres[trim($key)] = trim($value);
                }
            }
            $this->lastResponse['header'] = $hres;
        }
        $this->lastResponse['body'] = substr( $response, $header_size );
        $this->lastResponse['http_code'] = curl_getinfo($ch,CURLINFO_HTTP_CODE);
        $this->lastResponse['last_url'] = curl_getinfo($ch,CURLINFO_EFFECTIVE_URL);

        return $this->lastResponse['body'];
    }

    #endregion utils

    #region statics

    protected static function checkRequestTime()
    {
        if (empty(self::$lastRequestTime)) {
            self::$lastRequestTime = microtime(true);
            return;
        }
        $now = microtime(true);

        $control = self::$lastRequestTime + self::LIMIT_MICROTIME + 60; // + 60 opsion
        if ($now < $control) {
            $sleep = (int)($control - $now);
            usleep($sleep * 1000);
        }
    }

    #endregion statics


}