<?php


namespace Gek\PhpLang;


use Gek\Infrastructure\FlagEnumType;

/**
 * TypeUsage sınıfı
 *  tür bilgirimlerinin kullanılabileceği yerleri tutan sınıf.
 * @package Gek\PhpLang
 * @method static TypeUsage FIELD_USE()
 * @method static TypeUsage RETURN_USE()
 * @method static TypeUsage PARAM_USE()
 * @method static TypeUsage COMMENT_USE()
 * @method static TypeUsage ALL()
 */
class TypeUsage extends FlagEnumType
{
    /**
     * sınıf özelliğinde (property)
     */
    const FIELD_USE = 1;

    /**
     * metod dönüş türü bildiriminde
     */
    const RETURN_USE = 2;

    /**
     * metod ya da fonksiyon parametre tür bildiriminde
     */
    const PARAM_USE = 4;

    /**
     * doc comment içinde
     */
    const COMMENT_USE = 8;

    /**
     * tümünde
     */
    const ALL = self::FIELD_USE | self::RETURN_USE | self::PARAM_USE | self::COMMENT_USE;

}
