<?php


namespace Gek\PhpLang\Traits;


use Gek\PhpLang\PhpVisibility;

/**
 * VisibilityAware Trait
 * Erişebilirlik nitelikleri.
 * @package Gek\PhpLang\Traits
 */
trait VisibilityAware
{
    /**
     * Erişebilirlik
     * @var PhpVisibility
     */
    protected PhpVisibility $visibility;

    /**
     * Erişebilirlik değerini verir.
     * @return PhpVisibility
     */
    public function getVisibility():PhpVisibility{
        if(!isset($this->visibility) || empty($this->visibility)){
            $this->visibility = PhpVisibility::PUBLIC();
        }
        return $this->visibility;
    }

    /**
     * Erişebilirlik değerini set eder.
     * @param PhpVisibility $visibility
     * @return self
     */
    public function setVisibility(PhpVisibility $visibility):self {
        $this->visibility = $visibility;
        return $this;
    }

    /**
     * Erişebilirlik değerini private yapar.
     * @return self
     */
    public function setPrivate():self {
        $this->visibility = PhpVisibility::PRIVATE();
        return $this;
    }

    /**
     * Erişebilirlik değerini public yapar.
     * @return self
     */
    public function setPublic():self {
        $this->visibility = PhpVisibility::PUBLIC();
        return $this;
    }

    /**
     * Erişebilirlik değerini protected yapar.
     * @return self
     */
    public function setProtected():self {
        $this->visibility = PhpVisibility::PROTECTED();
        return $this;
    }




}