<?php


namespace Gek\PhpLang\Traits;

/**
 * RegionAware Trait
 * Region nitelikleri.
 * @package Gek\PhpLang\Traits
 */
trait RegionAware
{

    #region fields

    /**
     * Region
     * @var string|null
     */
    protected ?string $region = null;

    #endregion fields

    #region properties

    /**
     * Region getter.
     * @return string|null region adı
     */
    public function getRegion():?string {
        return $this->region;
    }

    /**
     * #region setter.
     * @param string|null $region region adı
     * @return self
     */
    public function setRegion(?string $region):self {
        $this->region = $region;
        return $this;
    }

    /**
     * region tanımlı mı?
     * @return bool tanımlı ise true değişlse false
     */
    public function hasRegion():bool {
        return $this->region !== null;
    }

    #endregion properties

}
