<?php


namespace Gek\PhpLang\Traits;

/**
 * MagicGetSetAware Trait
 *
 * Sihirli __get ve __set yöntem nitelikleri.
 *
 * @package Gek\PhpLang\Traits
 */
trait MagicGetSetAware
{
    /**
     * sihirli __get yöntemi
     *
     * @see https://www.php.net/manual/en/language.oop5.overloading.php#object.get Php sihirli __get yöntemi
     * @param string $name property adı
     * @return mixed|null property değeri
     */
    public function __get($name)
    {
        $result = null;
        $method = 'get'.ucwords($name);
        if (method_exists($this, $method))
        {
            $result = $this->$method();
        }
        return $result;
    }

    /**
     * sihirli __set yöntemi.
     *
     * @see https://www.php.net/manual/en/language.oop5.overloading.php#object.set Php sihirli __set yöntemi
     * @param string $name property adı
     * @param mixed $value değer
     * @return $this
     */
    public function __set($name, $value)
    {
        $method = 'set'.ucwords($name);
        if (method_exists($this, $method))
        {
            $this->$method($value);
            return $this;
        }
        $this->$name = $value;
        return $this;
    }

}
