<?php


namespace Gek\PhpLang\Traits;

/**
 * FinalAware Trait
 *
 * Final nitelikleri.
 *
 * @package Gek\PhpLang\Traits
 */
trait FinalAware
{

    /**
     * final
     * @var bool
     */
    protected bool $final = false;

    /**
     * final mi ?
     * @return bool final ise true değilse false
     */
    public function isFinal():bool {
        return $this->final;
    }

    /**
     * final durumunu değiştir.
     * @param bool $final final
     * @return self
     */
    public function setFinal(bool $final = true):self {
        $this->final = $final;
        return $this;
    }

}