<?php


namespace Gek\PhpLang\Traits;


use Gek\PhpLang\DocComments\DocComment;
use Gek\PhpLang\DocComments\DocCommentTag;

/**
 * DocCommentAware Trait
 *
 * DocComment nitelikleri
 *
 * @package Gek\PhpLang\Traits
 */
trait DocCommentAware
{

    /**
     * DocComment
     * @var DocComment
     */
    protected DocComment $docComment;


    /**
     * docComment getter
     *
     * @return DocComment
     */
    public function getDocComment():DocComment{
        if(!isset($this->docComment) || empty($this->docComment)){
            $this->docComment = new DocComment();
        }
        return $this->docComment;
    }

    /**
     * docComment setter
     * @param DocComment $docComment
     * @return self
     */
    public function setDocComment(DocComment $docComment):self {
        $this->docComment = $docComment;

        return $this;
    }

    /**
     * yeni docComment tag ekler.
     *
     * @param DocCommentTag|string $tag tag veya tag adı
     * @param string|null $value  tag değeri
     * @return self
     */
    public function addCommentTag($tag, ?string $value = ""):self {
        $this->getDocComment()->addTag($tag,$value);
        return $this;
    }

    /**
     * docComment özetine ek yapar.
     * @param string $summaryLine özet satırı.
     * @return self
     */
    public function addCommentSummary(string $summaryLine):self {
        $this->getDocComment()->addSummary($summaryLine);
        return $this;
    }

    /**
     * docComment açıklamasına ek yapar.
     * @param string $descriptionLine açıklama satırı.
     * @return self
     */
    public function addCommentDescription(string $descriptionLine):self {
        $this->getDocComment()->addDescription($descriptionLine);
        return $this;
    }




}