<?php


namespace Gek\PhpLang\Events;


use Gek\Infrastructure\Events\EventArguments;

/**
 * PropertyChangedEventArgs Sınıfı
 *
 * Özerllik değişmesi olay argumanları sınıfı.
 *
 * @package Gek\PhpLang\Events
 */
class PropertyChangedEventArgs extends EventArguments
{
    #region fields

    /**
     * property adı
     *
     * @var string
     */
    protected string $property;

    /**
     * eski değer
     *
     * @var mixed
     */
    protected $oldValue;

    /**
     * yeni değer
     *
     * @var mixed
     */
    protected $newValue;

    #endregion fields

    #region ctor

    /**
     * PropertyChangedEventArgs yapıcı metod.
     *
     * @param string $property özellik adı.
     * @param mixed $oldValue eski değer
     * @param mixed $newValue yeni değer.
     */
    public function __construct(string $property, $oldValue,$newValue)
    {
        $this->property = $property;
        $this->oldValue = $oldValue;
        $this->newValue = $newValue;
    }

    #endregion ctor

    #region property


    /**
     * property adı
     *
     * @return string
     */
    public function getProperty(): string
    {
        return $this->property;
    }

    /**
     * eski değer
     *
     * @return mixed
     */
    public function getOldValue()
    {
        return $this->oldValue;
    }

    /**
     * yeni değer
     *
     * @return mixed
     */
    public function getNewValue()
    {
        return $this->newValue;
    }

    #endregion property


}