---
title: \Gek\PhpLang\PhpClass
footer: false
---

# PhpClass

PhpClass sınıfı



örnek: [PhpClass](../../../examples/Gek/PhpLang/PhpClass_class/index.md)


* Full name (Tam Adı): `\Gek\PhpLang\PhpClass`
* Bu sınıf şu arayüzleri (interface) uygular:  \Gek\PhpLang\Contracts\IToIndentedString, \Serializable

**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/index.md)



## Methods (Yöntemler)

### __construct

PhpClass yapıcı metod.

```php
public PhpClass::__construct(string $name, \Gek\PhpLang\ClassTypes|null $classType = null): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | sınıf adı |
| `classType` | **\Gek\PhpLang\ClassTypes|null** | sınıf tipi |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/__construct_method.md)


---
### getClassType

Sınıf tipini verir.

```php
public PhpClass::getClassType(): \Gek\PhpLang\ClassTypes
```









**Return Value (Dönüş değeri):**


\Gek\PhpLang\ClassTypes



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/getClassType_method.md)


---
### setClassType

Sınıf tipini set eder

```php
public PhpClass::setClassType(\Gek\PhpLang\ClassTypes $classType): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `classType` | **\Gek\PhpLang\ClassTypes** |  |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/setClassType_method.md)


---
### getNamespace

Ad alanını verir

```php
public PhpClass::getNamespace(): string|null
```









**Return Value (Dönüş değeri):**


string|null



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/getNamespace_method.md)


---
### setNamespace

Ad alanını set eder

```php
public PhpClass::setNamespace(string|null $namespace): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `namespace` | **string|null** | ad alanı |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/setNamespace_method.md)


---
### getExtends

Üst sınıfı verir.

```php
public PhpClass::getExtends(): \Gek\PhpLang\PhpType|null
```









**Return Value (Dönüş değeri):**


\Gek\PhpLang\PhpType|null



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/getExtends_method.md)


---
### setExtends

Üst sınıfı set eder.

```php
public PhpClass::setExtends(\Gek\PhpLang\PhpType|string|null $extends): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `extends` | **\Gek\PhpLang\PhpType|string|null** | Üst sınıf |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/setExtends_method.md)


---
### getImplements

Implemente edilen arayüz koleksiyonunu verir.

```php
public PhpClass::getImplements(): \Gek\PhpLang\Collections\PhpTypeCollection
```









**Return Value (Dönüş değeri):**


\Gek\PhpLang\Collections\PhpTypeCollection



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/getImplements_method.md)


---
### setImplements

Implemente edilen arayüz koleksiyonunu set eder.

```php
public PhpClass::setImplements(\Gek\PhpLang\Collections\PhpTypeCollection $implements): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `implements` | **\Gek\PhpLang\Collections\PhpTypeCollection** | arayüz koleksiyonu |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/setImplements_method.md)


---
### getMembers

Sınıf üyesi koleksiyonunu verir.

```php
public PhpClass::getMembers(): \Gek\PhpLang\Collections\ClassMemberCollection
```









**Return Value (Dönüş değeri):**


\Gek\PhpLang\Collections\ClassMemberCollection



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/getMembers_method.md)


---
### setMembers

Sınıf üyeleri koleksiyonunu set eder.

```php
public PhpClass::setMembers(\Gek\PhpLang\Collections\ClassMemberCollection $members): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `members` | **\Gek\PhpLang\Collections\ClassMemberCollection** | Sınıf öğeleri koleksiyonu |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/setMembers_method.md)


---
### getTraits

Kullanılan trait koleksiyonunu verir.

```php
public PhpClass::getTraits(): \Gek\PhpLang\Collections\TraitItemCollection
```









**Return Value (Dönüş değeri):**


\Gek\PhpLang\Collections\TraitItemCollection



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/getTraits_method.md)


---
### setTraits

Kullanılan trait koleksiyonunu set eder.

```php
public PhpClass::setTraits(\Gek\PhpLang\Collections\TraitItemCollection $traits): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `traits` | **\Gek\PhpLang\Collections\TraitItemCollection** | trait koleksiyonu |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/setTraits_method.md)


---
### getUses

import koleksiyonunu verir.

```php
public PhpClass::getUses(): \Gek\PhpLang\Collections\UseItemCollection
```









**Return Value (Dönüş değeri):**


\Gek\PhpLang\Collections\UseItemCollection



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/getUses_method.md)


---
### setUses

import koleksiyonunu set eder.

```php
public PhpClass::setUses(\Gek\PhpLang\Collections\UseItemCollection $uses): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `uses` | **\Gek\PhpLang\Collections\UseItemCollection** | import koleksiyonu |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/setUses_method.md)


---
### getInterfaceExtends

Üst arayüzler koleksiyonunu verir.

```php
public PhpClass::getInterfaceExtends(): \Gek\PhpLang\Collections\PhpTypeCollection
```









**Return Value (Dönüş değeri):**


\Gek\PhpLang\Collections\PhpTypeCollection



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/getInterfaceExtends_method.md)


---
### setInterfaceExtends

Üst arayüzler koleksiyonunu set eder.

```php
public PhpClass::setInterfaceExtends(\Gek\PhpLang\Collections\PhpTypeCollection $interfaceExtends): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `interfaceExtends` | **\Gek\PhpLang\Collections\PhpTypeCollection** | arayüz koleksiyonu |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/setInterfaceExtends_method.md)


---
### isAutoDocComment

otomatik docComment modu aktif mi?

```php
public PhpClass::isAutoDocComment(): bool
```









**Return Value (Dönüş değeri):**


bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/isAutoDocComment_method.md)


---
### setAutoDocComment

otomatik docComment modunu aktif ya da pasif yapar.

```php
public PhpClass::setAutoDocComment(bool $autoDocComment): $this
```

.






**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `autoDocComment` | **bool** | true ise aktif false ise pasif |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/setAutoDocComment_method.md)


---
### isInterface

bu sınıf arayüz mü?

```php
public PhpClass::isInterface(): bool
```









**Return Value (Dönüş değeri):**

arayüz ise true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/isInterface_method.md)


---
### isTrait

bu sınıf trait mi?

```php
public PhpClass::isTrait(): bool
```









**Return Value (Dönüş değeri):**

tarit ise true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/isTrait_method.md)


---
### isClass

bu sınıf sınıf mı?

```php
public PhpClass::isClass(): bool
```









**Return Value (Dönüş değeri):**

sınıf ise true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/isClass_method.md)


---
### addUse

import ekler

```php
public PhpClass::addUse(\Gek\PhpLang\UseItem|string $use, string|null $aliasName = null): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `use` | **\Gek\PhpLang\UseItem|string** | import türü |
| `aliasName` | **string|null** | (opsiyonel) takma ad |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/addUse_method.md)


---
### getFullName

Sınıfın tam adını verir.

```php
public PhpClass::getFullName(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/getFullName_method.md)


---
### hasExtends

Üst sınıf tanımlı mı?

```php
public PhpClass::hasExtends(): bool
```









**Return Value (Dönüş değeri):**

tanımlı ise true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/hasExtends_method.md)


---
### hasImplements

implemente edilen arayüz var mı?

```php
public PhpClass::hasImplements(): bool
```









**Return Value (Dönüş değeri):**

varsa true yoksa false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/hasImplements_method.md)


---
### addImplement

implemente edilen arayüz ekler.

```php
public PhpClass::addImplement(\Gek\PhpLang\PhpType|string $implement): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `implement` | **\Gek\PhpLang\PhpType|string** | arayüz |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/addImplement_method.md)


---
### addMember

Sınıf üyesi ekler.

```php
public PhpClass::addMember(\Gek\PhpLang\ClassMember $member): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `member` | **\Gek\PhpLang\ClassMember** | sınıf üyesi |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/addMember_method.md)


---
### addExtendsForInterface

Üst arayüz ekler.

```php
public PhpClass::addExtendsForInterface(\Gek\PhpLang\PhpType|string $extends): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `extends` | **\Gek\PhpLang\PhpType|string** | üst arayüz |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/addExtendsForInterface_method.md)


---
### getMemberByName

Adı verilen sınıf öğesini verir.

```php
public PhpClass::getMemberByName(string $name): \Gek\PhpLang\ClassMember|null
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | öğe adı |


**Return Value (Dönüş değeri):**

sınıf öğesi (bulunamazsa null)
\Gek\PhpLang\ClassMember|null



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/getMemberByName_method.md)


---
### addField

alan (property) ekler.

```php
public PhpClass::addField(string $name, \Gek\PhpLang\PhpTypeDeclared|array|string|null $type = null): \Gek\PhpLang\ClassField
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | alan adı |
| `type` | **\Gek\PhpLang\PhpTypeDeclared|array|string|null** | tipi |


**Return Value (Dönüş değeri):**

eklenen alan
\Gek\PhpLang\ClassField



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/addField_method.md)


---
### getFieldByName

verilen ada göre alanı (property) verir.

```php
public PhpClass::getFieldByName(string $name): \Gek\PhpLang\ClassField|null
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | alan adı |


**Return Value (Dönüş değeri):**

alan (bulunamazsa null)
\Gek\PhpLang\ClassField|null



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/getFieldByName_method.md)


---
### addMethod

metod ekler.

```php
public PhpClass::addMethod(string $name): \Gek\PhpLang\ClassMethod
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | metod adı |


**Return Value (Dönüş değeri):**

eklenen metod
\Gek\PhpLang\ClassMethod



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/addMethod_method.md)


---
### getMethodByName

verilen ada göre metodu verir.

```php
public PhpClass::getMethodByName(string $name): \Gek\PhpLang\ClassMethod|null
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | metod adı |


**Return Value (Dönüş değeri):**

metod (bulunamazsa null)
\Gek\PhpLang\ClassMethod|null



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/getMethodByName_method.md)


---
### addConstructor

yapıcı metod ekler.

```php
public PhpClass::addConstructor(string|true|null $region = null): \Gek\PhpLang\ClassMethod
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `region` | **string|true|null** | bölge adı (true ise otomatik oluşturur) |


**Return Value (Dönüş değeri):**

// yapıcı metod
\Gek\PhpLang\ClassMethod



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/addConstructor_method.md)


---
### addTrait

Kullanılan trait ekler.

```php
public PhpClass::addTrait(\Gek\PhpLang\TraitItem|string $trait, \Gek\Collections\Enumerable|\Gek\Collections\Typed\StringDictionary|array|string[]|null $aliases = null): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `trait` | **\Gek\PhpLang\TraitItem|string** | trait |
| `aliases` | **\Gek\Collections\Enumerable|\Gek\Collections\Typed\StringDictionary|array|string[]|null** |  |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/addTrait_method.md)


---
### addProperty

getter ve setter metodları ile property  ekler.

```php
public PhpClass::addProperty(string $name, \Gek\PhpLang\PhpTypeDeclared|array|string|null $type = null, bool $get = true, bool $set = true): \Gek\PhpLang\ClassField
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | property adı |
| `type` | **\Gek\PhpLang\PhpTypeDeclared|array|string|null** | tipi |
| `get` | **bool** | getter methodu oluştur |
| `set` | **bool** | setter methodu oluştur |


**Return Value (Dönüş değeri):**

property için eklenen alan
\Gek\PhpLang\ClassField



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/addProperty_method.md)


---
### __toString

sınıfı metne (php koduna) çeviirir

```php
public PhpClass::__toString(): string
```









**Return Value (Dönüş değeri):**

menşt (php kodu)
string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/__toString_method.md)


---
### toIndentedString

sınıfı girintili metnini (kod halini)  verir.

```php
public PhpClass::toIndentedString(int $indentLevel, string $indentChars = &#039;    &#039;): string
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `indentLevel` | **int** | girinti seviyesi |
| `indentChars` | **string** | girinti karakterleri |


**Return Value (Dönüş değeri):**

girintili metin (php kodu)
string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/toIndentedString_method.md)


---
### syncUses

import edilen türleri sınıf öğelerini tarayarak senkronize eder.

```php
public PhpClass::syncUses(): mixed
```









**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/syncUses_method.md)


---
### serialize

String representation of object

```php
public PhpClass::serialize(): string
```









**Return Value (Dönüş değeri):**

the string representation of the object or null
string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/serialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.serialize.php - 


---
### unserialize

Constructs the object

```php
public PhpClass::unserialize(string $serialized): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `serialized` | **string** | &lt;p&gt;<br />The string representation of the object.<br />&lt;/p&gt; |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/unserialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.unserialize.php - 


---


## Inherited methods (kalıtsal yöntemler)

### getDocComment

docComment getter

```php
public DocCommentAware::getDocComment(): \Gek\PhpLang\DocComments\DocComment
```









**Return Value (Dönüş değeri):**


\Gek\PhpLang\DocComments\DocComment



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/getDocComment_method.md)


---
### setDocComment

docComment setter

```php
public DocCommentAware::setDocComment(\Gek\PhpLang\DocComments\DocComment $docComment): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `docComment` | **\Gek\PhpLang\DocComments\DocComment** |  |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/setDocComment_method.md)


---
### addCommentTag

yeni docComment tag ekler.

```php
public DocCommentAware::addCommentTag(\Gek\PhpLang\DocComments\DocCommentTag|string $tag, string|null $value = &quot;&quot;): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `tag` | **\Gek\PhpLang\DocComments\DocCommentTag|string** | tag veya tag adı |
| `value` | **string|null** | tag değeri |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/addCommentTag_method.md)


---
### addCommentSummary

docComment özetine ek yapar.

```php
public DocCommentAware::addCommentSummary(string $summaryLine): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `summaryLine` | **string** | özet satırı. |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/addCommentSummary_method.md)


---
### addCommentDescription

docComment açıklamasına ek yapar.

```php
public DocCommentAware::addCommentDescription(string $descriptionLine): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `descriptionLine` | **string** | açıklama satırı. |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/addCommentDescription_method.md)


---
### isAbstract

soyut mu ?

```php
public AbstractAware::isAbstract(): bool
```









**Return Value (Dönüş değeri):**

soyutsa true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/isAbstract_method.md)


---
### setAbstract

soyut durumunu değiştir.

```php
public AbstractAware::setAbstract(bool $abstract = true): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `abstract` | **bool** | soyut |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/setAbstract_method.md)


---
### isFinal

final mi ?

```php
public FinalAware::isFinal(): bool
```









**Return Value (Dönüş değeri):**

final ise true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/isFinal_method.md)


---
### setFinal

final durumunu değiştir.

```php
public FinalAware::setFinal(bool $final = true): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `final` | **bool** | final |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/setFinal_method.md)


---
### getName

Name getter.

```php
public NameAware::getName(): string
```









**Return Value (Dönüş değeri):**

ad
string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/getName_method.md)


---
### setName

Name setter

```php
public NameAware::setName(string $name): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | ad |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpClass_class/setName_method.md)


---


---
> 2022-04-15 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
