---
title: \Gek\PhpLang\Collections\TraitItemCollection
footer: false
---

# TraitItemCollection

TraitItemCollection Sınıfı

Kullanılan traitler koleksiyonu.

örnek: [TraitItemCollection](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/index.md)


* Full name (Tam Adı): `\Gek\PhpLang\Collections\TraitItemCollection`
* Parent class (Üst Sınıf): [TypedListWrapper](../../../../classes.md)
* Bu sınıf şu arayüzleri (interface) uygular:  \Gek\PhpLang\Contracts\IUseCreator, \Gek\PhpLang\Contracts\IToIndentedString, \Serializable

**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/index.md)



## Methods (Yöntemler)

### __construct

TraitItemCollection yapıcı metod.

```php
public TraitItemCollection::__construct(\Gek\PhpLang\TraitItem $items): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `items` | **\Gek\PhpLang\TraitItem** | (opsiyonel) öğeler |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/__construct_method.md)


---
### add

öğe ekler

```php
public TraitItemCollection::add(\Gek\PhpLang\TraitItem $item): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\TraitItem** | öğe |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/add_method.md)


---
### addRange

çoklu öğe ekler

```php
public TraitItemCollection::addRange(\Gek\PhpLang\TraitItem $items): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `items` | **\Gek\PhpLang\TraitItem** | öğeler |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/addRange_method.md)


---
### contains

öğenin koleksiyonda olup olmadığına bakar.

```php
public TraitItemCollection::contains(\Gek\PhpLang\TraitItem $item): bool
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\TraitItem** | öğe |


**Return Value (Dönüş değeri):**

varsa true yoksa false
bool



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/contains_method.md)


---
### remove

öğeyi koleksiyondan kaldırır.

```php
public TraitItemCollection::remove(\Gek\PhpLang\TraitItem $item): bool
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\TraitItem** | öğe |


**Return Value (Dönüş değeri):**

başarı durumunda true aksi halde false
bool



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/remove_method.md)


---
### indexOf

verilen öğenin koleksiyondaki indeksinin verir.

```php
public TraitItemCollection::indexOf(\Gek\PhpLang\TraitItem $item): int
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\TraitItem** | öğe |


**Return Value (Dönüş değeri):**

öğenin indeksi, öğe bulunamazsa -1
int



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/indexOf_method.md)


---
### insert

verilen indekse öğeyi ekler.

```php
public TraitItemCollection::insert(int $index, \Gek\PhpLang\TraitItem $item): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |
| `item` | **\Gek\PhpLang\TraitItem** | öğe |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/insert_method.md)


---
### getAt

verilen indeksteki öğeyi verir.

```php
public TraitItemCollection::getAt(int $index): \Gek\PhpLang\TraitItem
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |


**Return Value (Dönüş değeri):**

öğe
\Gek\PhpLang\TraitItem



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/getAt_method.md)


---
### setAt

verilen indekse öğeyi set eder.

```php
public TraitItemCollection::setAt(int $index, \Gek\PhpLang\TraitItem $item): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |
| `item` | **\Gek\PhpLang\TraitItem** | öğe |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/setAt_method.md)


---
### insertRange

verilen indekse çoklu öğe ekler.

```php
public TraitItemCollection::insertRange(int $index, \Gek\PhpLang\TraitItem $items): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |
| `items` | **\Gek\PhpLang\TraitItem** | öğeler |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/insertRange_method.md)


---
### __toString

koleksiyonu metne (php koduna) çevirir.

```php
public TraitItemCollection::__toString(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/__toString_method.md)


---
### getUseArray

koleksiyondaki türleri verir.

```php
public TraitItemCollection::getUseArray(): array|\Gek\PhpLang\UseItem[]
```









**Return Value (Dönüş değeri):**


array|\Gek\PhpLang\UseItem[]



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/getUseArray_method.md)


---
### toIndentedString

girintili metni (php kodunu) verir.

```php
public TraitItemCollection::toIndentedString(int $indentLevel, string $indentChars = &#039;    &#039;): string
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `indentLevel` | **int** | (opsiyonel) girinti seviyesi |
| `indentChars` | **string** | (opsiyonel) girinti karakterleri |


**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/toIndentedString_method.md)


---
### serialize

String representation of object

```php
public TraitItemCollection::serialize(): string
```









**Return Value (Dönüş değeri):**

the string representation of the object or null
string



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/serialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.serialize.php - 


---
### unserialize

Constructs the object

```php
public TraitItemCollection::unserialize(string $serialized): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `serialized` | **string** | &lt;p&gt;<br />The string representation of the object.<br />&lt;/p&gt; |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/TraitItemCollection_class/unserialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.unserialize.php - 


---


---
> 2022-04-15 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
