---
title: \Gek\PhpLang\Collections\MethodParamCollection
footer: false
---

# MethodParamCollection

MethodParamCollection Sınıfı

Metod parametreleri koleksiyonu

örnek: [MethodParamCollection](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/index.md)


* Full name (Tam Adı): `\Gek\PhpLang\Collections\MethodParamCollection`
* Parent class (Üst Sınıf): [TypedListWrapper](../../../../classes.md)
* Bu sınıf şu arayüzleri (interface) uygular:  \Gek\PhpLang\Contracts\IUseCreator, \Serializable

**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/index.md)



## Methods (Yöntemler)

### __construct

MethodParamCollection yapıcı sınıf.

```php
public MethodParamCollection::__construct(\Gek\PhpLang\MethodParam $items): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `items` | **\Gek\PhpLang\MethodParam** | (opsiyonel) öğeler |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/__construct_method.md)


---
### add

öğe ekler

```php
public MethodParamCollection::add(\Gek\PhpLang\MethodParam $item): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\MethodParam** | öğe |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/add_method.md)


---
### addRange

çoklu öğe ekler

```php
public MethodParamCollection::addRange(\Gek\PhpLang\MethodParam $items): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `items` | **\Gek\PhpLang\MethodParam** | öğeler |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/addRange_method.md)


---
### contains

öğenin koleksiyonda olup olmadığına bakar.

```php
public MethodParamCollection::contains(\Gek\PhpLang\MethodParam $item): bool
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\MethodParam** | öğe |


**Return Value (Dönüş değeri):**

varsa true yoksa false
bool



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/contains_method.md)


---
### remove

öğeyi koleksiyondan kaldırır

```php
public MethodParamCollection::remove(\Gek\PhpLang\MethodParam $item): bool
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\MethodParam** | öğe |


**Return Value (Dönüş değeri):**

Başarı halinde true aksi halde false
bool



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/remove_method.md)


---
### indexOf

öğenin koleksiyondaki indeksini verir.

```php
public MethodParamCollection::indexOf(\Gek\PhpLang\MethodParam $item): int
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\MethodParam** | öpe |


**Return Value (Dönüş değeri):**

öğenin indeksi, öğe bulunamazsa -1
int



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/indexOf_method.md)


---
### insert

verilen indekse öğe ekler

```php
public MethodParamCollection::insert(int $index, \Gek\PhpLang\MethodParam $item): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |
| `item` | **\Gek\PhpLang\MethodParam** | öğe |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/insert_method.md)


---
### getAt

verilen indeksteki öğeyi verir.

```php
public MethodParamCollection::getAt(int $index): \Gek\PhpLang\MethodParam
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |


**Return Value (Dönüş değeri):**

öğe
\Gek\PhpLang\MethodParam



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/getAt_method.md)


---
### setAt

verilen indeksteki öğeyi set eder.

```php
public MethodParamCollection::setAt(int $index, \Gek\PhpLang\MethodParam $item): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |
| `item` | **\Gek\PhpLang\MethodParam** | öğe |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/setAt_method.md)


---
### insertRange

verilen indekse çoklu öğe ekler.

```php
public MethodParamCollection::insertRange(int $index, \Gek\PhpLang\MethodParam $items): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |
| `items` | **\Gek\PhpLang\MethodParam** | öğeler |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/insertRange_method.md)


---
### addParam

yeni öğe oluşturup koleksiyona ekler

```php
public MethodParamCollection::addParam(\Gek\PhpLang\MethodParam|string $param, \Gek\PhpLang\PhpTypeDeclared|array|string|null $type = null, string|null $val = null, int|null $renderType = null): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `param` | **\Gek\PhpLang\MethodParam|string** | parametre adı |
| `type` | **\Gek\PhpLang\PhpTypeDeclared|array|string|null** | (opsiyonel) parametre tipi |
| `val` | **string|null** | (opsiyoney) parametre varsayılan değeri |
| `renderType` | **int|null** | (opsiyonel) render tipi |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/addParam_method.md)


---
### addParams

verilenparametre php kodundan öğeleri ayrırştırır ve koleksiyona ekler

```php
public MethodParamCollection::addParams(string $params): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `params` | **string** | php parametre kodu (örn. &quot;$param, $type = null, ?string $val = null, ?int $renderType = null&quot; ) |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/addParams_method.md)


---
### __toString

koleksiyonu metne (php koduna) çevirir.

```php
public MethodParamCollection::__toString(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/__toString_method.md)


---
### getUseArray

koleksiyondaki parametre tiplerini verir.

```php
public MethodParamCollection::getUseArray(): array|\Gek\PhpLang\UseItem[]
```









**Return Value (Dönüş değeri):**

parametre tipleri
array|\Gek\PhpLang\UseItem[]



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/getUseArray_method.md)


---
### serialize

String representation of object

```php
public MethodParamCollection::serialize(): string
```









**Return Value (Dönüş değeri):**

the string representation of the object or null
string



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/serialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.serialize.php - 


---
### unserialize

Constructs the object

```php
public MethodParamCollection::unserialize(string $serialized): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `serialized` | **string** | &lt;p&gt;<br />The string representation of the object.<br />&lt;/p&gt; |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/MethodParamCollection_class/unserialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.unserialize.php - 


---


---
> 2022-04-15 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
