---
title: \Gek\PhpLang\CodeLine
footer: false
---

# CodeLine

CodeLine sınıfı
kod satırını tutar



örnek: [CodeLine](../../../examples/Gek/PhpLang/CodeLine_class/index.md)


* Full name (Tam Adı): `\Gek\PhpLang\CodeLine`
* Bu sınıf şu arayüzleri (interface) uygular:  \Gek\PhpLang\Contracts\IToIndentedString, \Serializable

**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeLine_class/index.md)



## Methods (Yöntemler)

### __construct

CodeLine yapıcı metod.

```php
public CodeLine::__construct(string $code = &#039;&#039;, int $indentLevel): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `code` | **string** | kod metni |
| `indentLevel` | **int** | girinti düzeyi |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeLine_class/__construct_method.md)


---
### getCode

Kod metnini verir.

```php
public CodeLine::getCode(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeLine_class/getCode_method.md)


---
### setCode

Kod metnini set eder.

```php
public CodeLine::setCode(string $code): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `code` | **string** | kod metni |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeLine_class/setCode_method.md)


---
### getIndentLevel

Girinti düzeyini verir.

```php
public CodeLine::getIndentLevel(): int
```









**Return Value (Dönüş değeri):**

girinti seviyesi
int



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeLine_class/getIndentLevel_method.md)


---
### setIndentLevel

Girinti seviyesini set eder.

```php
public CodeLine::setIndentLevel(int $indentLevel): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `indentLevel` | **int** | girinti seviyesi. |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeLine_class/setIndentLevel_method.md)


---
### incrementIndentLevel

Girinti seviyesini arttırır.

```php
public CodeLine::incrementIndentLevel(int $add = 1): int
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `add` | **int** | artış |


**Return Value (Dönüş değeri):**

geçerli girinti seviyesi
int



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeLine_class/incrementIndentLevel_method.md)


---
### decrementIndentLevel

Girinti seviyesini azaltır.

```php
public CodeLine::decrementIndentLevel(int $sub = 1): int
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `sub` | **int** | azaltılacak sayı |


**Return Value (Dönüş değeri):**

geçerli girinti seviyesi
int



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeLine_class/decrementIndentLevel_method.md)


---
### __toString

kod satırını metne (php koduna) çevirir.

```php
public CodeLine::__toString(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeLine_class/__toString_method.md)


---
### parseLine

Verilen metinden kod satırı oluşturur.

```php
public static CodeLine::parseLine(string $code): \Gek\PhpLang\CodeLine
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `code` | **string** | kod metni |


**Return Value (Dönüş değeri):**

kod satırı.
\Gek\PhpLang\CodeLine



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeLine_class/parseLine_method.md)


---
### parseCodes

verilen metinden kod satırları oluşturur.

```php
public static CodeLine::parseCodes(string $codes): array
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `codes` | **string** | kod metni. |


**Return Value (Dönüş değeri):**

Kıd satırları.
array



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeLine_class/parseCodes_method.md)


---
### toIndentedString

kod satırını girintili metne (php koduna) çevirir.

```php
public CodeLine::toIndentedString(int $indentLevel, string $indentChars = &#039;    &#039;): string
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `indentLevel` | **int** | girinti düzeyi. |
| `indentChars` | **string** | girinti karakterleri |


**Return Value (Dönüş değeri):**

girintili metin (php kodu)
string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeLine_class/toIndentedString_method.md)


---
### serialize

String representation of object

```php
public CodeLine::serialize(): string
```









**Return Value (Dönüş değeri):**

the string representation of the object or null
string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeLine_class/serialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.serialize.php - 


---
### unserialize

Constructs the object

```php
public CodeLine::unserialize(string $serialized): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `serialized` | **string** | &lt;p&gt;<br />The string representation of the object.<br />&lt;/p&gt; |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeLine_class/unserialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.unserialize.php - 


---


---
> 2022-04-15 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
