---
title: \Gek\PhpLang\ClassMethod
footer: false
---

# ClassMethod

ClassMethod Sınıfı

Sınıf metodu sınıfı

örnek: [ClassMethod](../../../examples/Gek/PhpLang/ClassMethod_class/index.md)


* Full name (Tam Adı): `\Gek\PhpLang\ClassMethod`
* Parent class (Üst Sınıf): [\Gek\PhpLang\ClassMember](./ClassMember.md)
* Bu sınıf şu arayüzleri (interface) uygular:  \Gek\PhpLang\Contracts\IToIndentedString, \Gek\PhpLang\Contracts\IUseCreator, \Serializable

**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/index.md)



## Methods (Yöntemler)

### __construct

ClassMethod yapıcı metod

```php
public ClassMethod::__construct(string $name, \Gek\PhpLang\PhpVisibility|null $visibility = null): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | metod adı |
| `visibility` | **\Gek\PhpLang\PhpVisibility|null** | metod erişebilirliği |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/__construct_method.md)


---
### setInterfaceMethod

arayüz metodu yap / kaldıri

```php
public ClassMethod::setInterfaceMethod(bool $interfaceMethod = true): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `interfaceMethod` | **bool** | true ise arayüz metodu yapar false ise kaldırır. |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setInterfaceMethod_method.md)


---
### getReturnType

metod dönüş türünü verir.

```php
public ClassMethod::getReturnType(): string|null
```









**Return Value (Dönüş değeri):**

dönüş türü
string|null



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/getReturnType_method.md)


---
### setReturnType

metod dönüş türünü set eder.

```php
public ClassMethod::setReturnType(\Gek\PhpLang\PhpTypeDeclared|array|string|null $returnType): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `returnType` | **\Gek\PhpLang\PhpTypeDeclared|array|string|null** | dönüş türü |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setReturnType_method.md)


---
### getParams

metod parametrelerini verir.

```php
public ClassMethod::getParams(): \Gek\PhpLang\Collections\MethodParamCollection
```









**Return Value (Dönüş değeri):**

parametre kolksiyonu
\Gek\PhpLang\Collections\MethodParamCollection



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/getParams_method.md)


---
### setParams

metod parametrelerini set eder.

```php
public ClassMethod::setParams(\Gek\PhpLang\Collections\MethodParamCollection $params): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `params` | **\Gek\PhpLang\Collections\MethodParamCollection** | parametre koleksiyonu |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setParams_method.md)


---
### getCodeLines

metod kodalrını verir.

```php
public ClassMethod::getCodeLines(): \Gek\PhpLang\Collections\CodeLineCollection
```









**Return Value (Dönüş değeri):**

kod satırı koleksiyonu
\Gek\PhpLang\Collections\CodeLineCollection



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/getCodeLines_method.md)


---
### setCodeLines

metod kodlarını set eder.

```php
public ClassMethod::setCodeLines(\Gek\PhpLang\Collections\CodeLineCollection $codeLines): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `codeLines` | **\Gek\PhpLang\Collections\CodeLineCollection** | kod satırı koleksiyonu |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setCodeLines_method.md)


---
### getBody

metod kodalrını metin olarak verir.

```php
public ClassMethod::getBody(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/getBody_method.md)


---
### setBody

metod kodlarını metin olarak set eder. (ayrıştırıp kod satırı koleksiyonuna çevirip set eder.)

```php
public ClassMethod::setBody(string $codes): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `codes` | **string** | kod metni |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setBody_method.md)


---
### isInterfaceMethod

arayüz metodu mu ?

```php
public ClassMethod::isInterfaceMethod(): bool
```









**Return Value (Dönüş değeri):**

arayüz metoduysa true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/isInterfaceMethod_method.md)


---
### hasParams

metodun parametreleri var mı?

```php
public ClassMethod::hasParams(): bool
```









**Return Value (Dönüş değeri):**

varsa true yoksa false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/hasParams_method.md)


---
### addParam

metoda parametre ekler.

```php
public ClassMethod::addParam(\Gek\PhpLang\MethodParam|string $param, string|null $type = null, string|null $val = null, int|null $renderType = null): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `param` | **\Gek\PhpLang\MethodParam|string** | parametre veya parametre adı |
| `type` | **string|null** | (opsiyonel) parametre türü. |
| `val` | **string|null** | (opsiyonel) parametre varsayılan değeri |
| `renderType` | **int|null** | (opsiyonel) parametre varsayılan değeri render tipi |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/addParam_method.md)


---
### addParams

metoda çoklu parametre ekler. (php kodu metin olarak verilir)

```php
public ClassMethod::addParams(string $params): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `params` | **string** | parametreler (php kodu) |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/addParams_method.md)


---
### addCodeLine

metoda kod satırı ekler.

```php
public ClassMethod::addCodeLine(\Gek\PhpLang\CodeLine|string $code, int $indentLevel): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `code` | **\Gek\PhpLang\CodeLine|string** | kode satırı veya kod metni |
| `indentLevel` | **int** | (opsiyonel) girinti düzeyi. |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/addCodeLine_method.md)


---
### addCodeLines

metoda çoklu kod satırı ekler (php kodu metin olarak verilir.)

```php
public ClassMethod::addCodeLines(string $code): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `code` | **string** | metin (php kodu) |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/addCodeLines_method.md)


---
### hasBody

metodun kodu olup olmadığına bakar.

```php
public ClassMethod::hasBody(): bool
```









**Return Value (Dönüş değeri):**

varsa true yoksa false.
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/hasBody_method.md)


---
### hasReturnType

metodun döüş türü olup olmadığına bakar.

```php
public ClassMethod::hasReturnType(): bool
```









**Return Value (Dönüş değeri):**

varsa true yoksa false.
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/hasReturnType_method.md)


---
### autoDocComment

metod için otomatik docComment oluşturur.

```php
public ClassMethod::autoDocComment(): self
```









**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/autoDocComment_method.md)


---
### __toString

metodu metne (php koduna) çevirir.

```php
public ClassMethod::__toString(): string
```









**Return Value (Dönüş değeri):**

metin (php kodu)
string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/__toString_method.md)


---
### toIndentedString

metodu girintili metne (php koduna) çevirir.

```php
public ClassMethod::toIndentedString(int $indentLevel, string $indentChars = &#039;    &#039;): string
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `indentLevel` | **int** | girinti düzeyi |
| `indentChars` | **string** | girinti karakterleri |


**Return Value (Dönüş değeri):**

girintili metin (php kodu)
string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/toIndentedString_method.md)


---
### getUseArray

metodun import edilecek türlerini verir.

```php
public ClassMethod::getUseArray(): array|\Gek\PhpLang\UseItem[]
```









**Return Value (Dönüş değeri):**


array|\Gek\PhpLang\UseItem[]



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/getUseArray_method.md)


---
### serialize

String representation of object

```php
public ClassMethod::serialize(): string
```









**Return Value (Dönüş değeri):**

the string representation of the object or null
string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/serialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.serialize.php - 


---
### unserialize

Constructs the object

```php
public ClassMethod::unserialize(string $serialized): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `serialized` | **string** | &lt;p&gt;<br />The string representation of the object.<br />&lt;/p&gt; |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/unserialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.unserialize.php - 


---


## Inherited methods (kalıtsal yöntemler)

### isStatic

Statik mi?

```php
public StaticAware::isStatic(): bool
```









**Return Value (Dönüş değeri):**

statikse true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/isStatic_method.md)


---
### setStatic

Statik durumunu değiştir.

```php
public StaticAware::setStatic(bool $static = true): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `static` | **bool** | sattik durumu |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setStatic_method.md)


---
### isAbstract

soyut mu ?

```php
public AbstractAware::isAbstract(): bool
```









**Return Value (Dönüş değeri):**

soyutsa true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/isAbstract_method.md)


---
### setAbstract

soyut durumunu değiştir.

```php
public AbstractAware::setAbstract(bool $abstract = true): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `abstract` | **bool** | soyut |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setAbstract_method.md)


---
### isFinal

final mi ?

```php
public FinalAware::isFinal(): bool
```









**Return Value (Dönüş değeri):**

final ise true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/isFinal_method.md)


---
### setFinal

final durumunu değiştir.

```php
public FinalAware::setFinal(bool $final = true): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `final` | **bool** | final |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setFinal_method.md)


---
### __construct

ClassMember yapıcı metod.

```php
public ClassMember::__construct(string $name, \Gek\PhpLang\PhpVisibility|null $visibility = null): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | üye adı |
| `visibility` | **\Gek\PhpLang\PhpVisibility|null** | üye erişebilirliği |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/__construct_method.md)


---
### autoDocComment

otomatik docCommnet oluşturur.

```php
public ClassMember::autoDocComment(): $this
```




* Bu yöntem **soyut (abstract)**.




**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/autoDocComment_method.md)


---
### getDataForSerialize

serrleştirme için veri dizisini verir.

```php
protected ClassMember::getDataForSerialize(): array
```









**Return Value (Dönüş değeri):**


array



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/getDataForSerialize_method.md)


---
### setDataForSerialize

verilen veri dizisinden sınıf verisini doldurur.

```php
protected ClassMember::setDataForSerialize(array $data): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `data` | **array** | veri dizisi |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setDataForSerialize_method.md)


---
### getName

Name getter.

```php
public NameAware::getName(): string
```









**Return Value (Dönüş değeri):**

ad
string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/getName_method.md)


---
### setName

Name setter

```php
public NameAware::setName(string $name): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | ad |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setName_method.md)


---
### getDocComment

docComment getter

```php
public DocCommentAware::getDocComment(): \Gek\PhpLang\DocComments\DocComment
```









**Return Value (Dönüş değeri):**


\Gek\PhpLang\DocComments\DocComment



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/getDocComment_method.md)


---
### setDocComment

docComment setter

```php
public DocCommentAware::setDocComment(\Gek\PhpLang\DocComments\DocComment $docComment): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `docComment` | **\Gek\PhpLang\DocComments\DocComment** |  |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setDocComment_method.md)


---
### addCommentTag

yeni docComment tag ekler.

```php
public DocCommentAware::addCommentTag(\Gek\PhpLang\DocComments\DocCommentTag|string $tag, string|null $value = &quot;&quot;): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `tag` | **\Gek\PhpLang\DocComments\DocCommentTag|string** | tag veya tag adı |
| `value` | **string|null** | tag değeri |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/addCommentTag_method.md)


---
### addCommentSummary

docComment özetine ek yapar.

```php
public DocCommentAware::addCommentSummary(string $summaryLine): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `summaryLine` | **string** | özet satırı. |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/addCommentSummary_method.md)


---
### addCommentDescription

docComment açıklamasına ek yapar.

```php
public DocCommentAware::addCommentDescription(string $descriptionLine): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `descriptionLine` | **string** | açıklama satırı. |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/addCommentDescription_method.md)


---
### getVisibility

Erişebilirlik değerini verir.

```php
public VisibilityAware::getVisibility(): \Gek\PhpLang\PhpVisibility
```









**Return Value (Dönüş değeri):**


\Gek\PhpLang\PhpVisibility



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/getVisibility_method.md)


---
### setVisibility

Erişebilirlik değerini set eder.

```php
public VisibilityAware::setVisibility(\Gek\PhpLang\PhpVisibility $visibility): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `visibility` | **\Gek\PhpLang\PhpVisibility** |  |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setVisibility_method.md)


---
### setPrivate

Erişebilirlik değerini private yapar.

```php
public VisibilityAware::setPrivate(): self
```









**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setPrivate_method.md)


---
### setPublic

Erişebilirlik değerini public yapar.

```php
public VisibilityAware::setPublic(): self
```









**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setPublic_method.md)


---
### setProtected

Erişebilirlik değerini protected yapar.

```php
public VisibilityAware::setProtected(): self
```









**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setProtected_method.md)


---
### getRegion

Region getter.

```php
public RegionAware::getRegion(): string|null
```









**Return Value (Dönüş değeri):**

region adı
string|null



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/getRegion_method.md)


---
### setRegion

#region setter.

```php
public RegionAware::setRegion(string|null $region): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `region` | **string|null** | region adı |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/setRegion_method.md)


---
### hasRegion

region tanımlı mı?

```php
public RegionAware::hasRegion(): bool
```









**Return Value (Dönüş değeri):**

tanımlı ise true değişlse false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/hasRegion_method.md)


---
### __get

sihirli __get yöntemi

```php
public MagicGetSetAware::__get(string $name): mixed|null
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | property adı |


**Return Value (Dönüş değeri):**

property değeri
mixed|null



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/__get_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/language.oop5.overloading.php#object.get - Php sihirli __get yöntemi


---
### __set

sihirli __set yöntemi.

```php
public MagicGetSetAware::__set(string $name, mixed $value): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | property adı |
| `value` | **mixed** | değer |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassMethod_class/__set_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/language.oop5.overloading.php#object.set - Php sihirli __set yöntemi


---


---
> 2022-04-15 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
