---
title: \Gek\PhpLang\ClassConst
footer: false
---

# ClassConst

ClassConst Sınıfı

Sınıf sabiti sınıfı

örnek: [ClassConst](../../../examples/Gek/PhpLang/ClassConst_class/index.md)


* Full name (Tam Adı): `\Gek\PhpLang\ClassConst`
* Parent class (Üst Sınıf): [\Gek\PhpLang\ClassMember](./ClassMember.md)
* Bu sınıf şu arayüzleri (interface) uygular:  \Gek\PhpLang\Contracts\IToIndentedString, \Serializable

**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/index.md)



## Methods (Yöntemler)

### __construct

ClassConst yapıcı metod.

```php
public ClassConst::__construct(string $name, mixed $value, int $valueRenderType = LiteralTypes::NONE): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | sabit ismi |
| `value` | **mixed** | sabit değeri |
| `valueRenderType` | **int** | sabit değeri render tipi |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/__construct_method.md)


---
### autoDocComment

otomatik docComment oluşturur

```php
public ClassConst::autoDocComment(): $this
```









**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/autoDocComment_method.md)


---
### __toString

Sınıf sabitini metne (php koduna) çevirir.

```php
public ClassConst::__toString(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/__toString_method.md)


---
### toIndentedString

Sınıf sabitini girintili metne (php koduna) çevirir.

```php
public ClassConst::toIndentedString(int $indentLevel, string $indentChars = &#039;    &#039;): string
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `indentLevel` | **int** | girinti düzeyi |
| `indentChars` | **string** | girinti karakterleri |


**Return Value (Dönüş değeri):**

girintili metin
string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/toIndentedString_method.md)


---
### serialize

String representation of object

```php
public ClassConst::serialize(): string
```









**Return Value (Dönüş değeri):**

the string representation of the object or null
string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/serialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.serialize.php - 


---
### unserialize

Constructs the object

```php
public ClassConst::unserialize(string $serialized): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `serialized` | **string** | &lt;p&gt;<br />The string representation of the object.<br />&lt;/p&gt; |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/unserialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.unserialize.php - 


---


## Inherited methods (kalıtsal yöntemler)

### getValue

Value getter

```php
public ValueAware::getValue(): mixed
```









**Return Value (Dönüş değeri):**

değer
mixed



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/getValue_method.md)


---
### setValue

Value Setter

```php
public ValueAware::setValue(mixed $value, int|null $renderType = null): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `value` | **mixed** | değer |
| `renderType` | **int|null** | render tipi |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/setValue_method.md)


---
### getValueRenderType

Değer render tipini verir.

```php
public ValueAware::getValueRenderType(): int
```









**Return Value (Dönüş değeri):**

render tipi
int



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/getValueRenderType_method.md)


---
### setValueRenderType

değer render tipini set eder.

```php
public ValueAware::setValueRenderType(int $valueRenderType): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `valueRenderType` | **int** | render tipi |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/setValueRenderType_method.md)


---
### isSetValue

değer set edilmiş mi?

```php
public ValueAware::isSetValue(): bool
```









**Return Value (Dönüş değeri):**

edilmişse true aksi halde false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/isSetValue_method.md)


---
### __construct

ClassMember yapıcı metod.

```php
public ClassMember::__construct(string $name, \Gek\PhpLang\PhpVisibility|null $visibility = null): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | üye adı |
| `visibility` | **\Gek\PhpLang\PhpVisibility|null** | üye erişebilirliği |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/__construct_method.md)


---
### autoDocComment

otomatik docCommnet oluşturur.

```php
public ClassMember::autoDocComment(): $this
```




* Bu yöntem **soyut (abstract)**.




**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/autoDocComment_method.md)


---
### getDataForSerialize

serrleştirme için veri dizisini verir.

```php
protected ClassMember::getDataForSerialize(): array
```









**Return Value (Dönüş değeri):**


array



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/getDataForSerialize_method.md)


---
### setDataForSerialize

verilen veri dizisinden sınıf verisini doldurur.

```php
protected ClassMember::setDataForSerialize(array $data): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `data` | **array** | veri dizisi |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/setDataForSerialize_method.md)


---
### getName

Name getter.

```php
public NameAware::getName(): string
```









**Return Value (Dönüş değeri):**

ad
string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/getName_method.md)


---
### setName

Name setter

```php
public NameAware::setName(string $name): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | ad |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/setName_method.md)


---
### getDocComment

docComment getter

```php
public DocCommentAware::getDocComment(): \Gek\PhpLang\DocComments\DocComment
```









**Return Value (Dönüş değeri):**


\Gek\PhpLang\DocComments\DocComment



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/getDocComment_method.md)


---
### setDocComment

docComment setter

```php
public DocCommentAware::setDocComment(\Gek\PhpLang\DocComments\DocComment $docComment): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `docComment` | **\Gek\PhpLang\DocComments\DocComment** |  |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/setDocComment_method.md)


---
### addCommentTag

yeni docComment tag ekler.

```php
public DocCommentAware::addCommentTag(\Gek\PhpLang\DocComments\DocCommentTag|string $tag, string|null $value = &quot;&quot;): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `tag` | **\Gek\PhpLang\DocComments\DocCommentTag|string** | tag veya tag adı |
| `value` | **string|null** | tag değeri |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/addCommentTag_method.md)


---
### addCommentSummary

docComment özetine ek yapar.

```php
public DocCommentAware::addCommentSummary(string $summaryLine): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `summaryLine` | **string** | özet satırı. |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/addCommentSummary_method.md)


---
### addCommentDescription

docComment açıklamasına ek yapar.

```php
public DocCommentAware::addCommentDescription(string $descriptionLine): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `descriptionLine` | **string** | açıklama satırı. |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/addCommentDescription_method.md)


---
### getVisibility

Erişebilirlik değerini verir.

```php
public VisibilityAware::getVisibility(): \Gek\PhpLang\PhpVisibility
```









**Return Value (Dönüş değeri):**


\Gek\PhpLang\PhpVisibility



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/getVisibility_method.md)


---
### setVisibility

Erişebilirlik değerini set eder.

```php
public VisibilityAware::setVisibility(\Gek\PhpLang\PhpVisibility $visibility): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `visibility` | **\Gek\PhpLang\PhpVisibility** |  |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/setVisibility_method.md)


---
### setPrivate

Erişebilirlik değerini private yapar.

```php
public VisibilityAware::setPrivate(): self
```









**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/setPrivate_method.md)


---
### setPublic

Erişebilirlik değerini public yapar.

```php
public VisibilityAware::setPublic(): self
```









**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/setPublic_method.md)


---
### setProtected

Erişebilirlik değerini protected yapar.

```php
public VisibilityAware::setProtected(): self
```









**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/setProtected_method.md)


---
### getRegion

Region getter.

```php
public RegionAware::getRegion(): string|null
```









**Return Value (Dönüş değeri):**

region adı
string|null



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/getRegion_method.md)


---
### setRegion

#region setter.

```php
public RegionAware::setRegion(string|null $region): self
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `region` | **string|null** | region adı |


**Return Value (Dönüş değeri):**


self



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/setRegion_method.md)


---
### hasRegion

region tanımlı mı?

```php
public RegionAware::hasRegion(): bool
```









**Return Value (Dönüş değeri):**

tanımlı ise true değişlse false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/hasRegion_method.md)


---
### __get

sihirli __get yöntemi

```php
public MagicGetSetAware::__get(string $name): mixed|null
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | property adı |


**Return Value (Dönüş değeri):**

property değeri
mixed|null



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/__get_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/language.oop5.overloading.php#object.get - Php sihirli __get yöntemi


---
### __set

sihirli __set yöntemi.

```php
public MagicGetSetAware::__set(string $name, mixed $value): $this
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | property adı |
| `value` | **mixed** | değer |


**Return Value (Dönüş değeri):**


$this



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/ClassConst_class/__set_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/language.oop5.overloading.php#object.set - Php sihirli __set yöntemi


---


---
> 2022-04-15 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
