<?php

use Gek\Collections\ArrayList;
use Gek\Collections\Enumerable;
use Gek\FileFinder\FileInfo;
use Gek\Infrastructure\Str;
use Gek\PhpLang\ClassMember;
use Gek\PhpLang\CodeFactory;
use Gek\PhpLang\CodeLine;
use Gek\PhpLang\Collections\CodeLineCollection;
use Gek\PhpLang\Collections\MethodParamCollection;
use Gek\PhpLang\Contracts\IToIndentedString;
use Gek\PhpLang\Contracts\IUseCreator;
use Gek\PhpLang\DocComments\DocComment;
use Gek\PhpLang\MethodParam;
use Gek\PhpLang\PhpTypeDeclared;
use Gek\PhpLang\PhpVisibility;
use Gek\PhpLang\Traits\AbstractAware;
use Gek\PhpLang\Traits\FinalAware;
use Gek\PhpLang\Traits\StaticAware;
use Gek\PhpLang\UseItem;
use phpDocumentor\Reflection\File\LocalFile;
use phpDocumentor\Reflection\Php\ProjectFactory;
use PhpParser\Node\Stmt\Function_;
use PhpParser\NodeDumper;
use PhpParser\NodeTraverser;
use PhpParser\NodeVisitorAbstract;
use PhpParser\ParserFactory;

include_once "vendor\autoload.php";

$testCls = CodeFactory::classCreate("Deneme");

$mth = $testCls->addMethod("test")
    ->setPublic()
    ->setBody('if ($result === 0) {
            throw new InvalidArgumentException(
                sprintf(\'"%s\" is not a valid Fqsen.\', $fqsen)
            );
        }')->addParam("result","int","0");
$testCls->setAutoDocComment(true);
$fl = "testtttt.php";
file_put_contents($fl,"<?php " . PHP_EOL . $testCls->toIndentedString());
exit(0);



class MenuItem
{

    #region fields

    /** @var Menu|MenuItem|null  */
    protected $parent = null;

    /**
     * @var string|null
     */
    protected ?string $text = null;

    /**
     * @var string|null
     */
    protected ?string $url = null;

    /**
     * @var string|null
     */
    protected ?string $systemName = null;

    /**
     * @var string|null
     */
    protected ?string $iconClass = null;

    /**
     * @var bool
     */
    protected bool $loginRequired = false;

    /**
     * @var array|string[]
     */
    protected array $requiredPermissionNames = array();

    /**
     * @var array|string[]
     */
    protected array $requiredRoles = array();

    /**
     * @var array
     */
    protected array $attributes = array();


    /**
     * @var ArrayList|MenuItem[]
     */
    protected ArrayList $childs;

    /**
     * @var bool|null
     */
    protected ?bool $active = null;

    protected bool $renderAsComment = false;

    #endregion fields

    #region ctor

    public function __construct(bool $renderAsComment = false)
    {
        $this->renderAsComment = $renderAsComment;
        $this->childs = new ArrayList();
    }

    #endregion ctor

    #region properties

    /**
     * @return string|null
     */
    public function getText(): ?string
    {
        return $this->text;
    }

    /**
     * @param string|null $text
     * @return MenuItem
     */
    public function setText(?string $text): MenuItem
    {
        $this->text = $text;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getUrl(): ?string
    {
        return $this->url;
    }

    /**
     * @param string|null $url
     * @return MenuItem
     */
    public function setUrl(?string $url): MenuItem
    {
        $this->url = $url;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSystemName(): ?string
    {
        return $this->systemName;
    }

    /**
     * @param string|null $systemName
     * @return MenuItem
     */
    public function setSystemName(?string $systemName): MenuItem
    {
        $this->systemName = $systemName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIconClass(): ?string
    {
        return $this->iconClass;
    }

    /**
     * @param string|null $iconClass
     * @return MenuItem
     */
    public function setIconClass(?string $iconClass): MenuItem
    {
        $this->iconClass = $iconClass;
        return $this;
    }

    /**
     * @return bool
     */
    public function isLoginRequired(): bool
    {
        return $this->loginRequired;
    }

    /**
     * @param bool $loginRequired
     * @return MenuItem
     */
    public function setLoginRequired(bool $loginRequired = true): MenuItem
    {
        $this->loginRequired = $loginRequired;
        return $this;
    }

    /**
     * @return array|string[]
     */
    public function getRequiredPermissionNames()
    {
        return $this->requiredPermissionNames;
    }

    /**
     * @param array|string[] $requiredPermissionNames
     * @return MenuItem
     */
    public function setRequiredPermissionNames($requiredPermissionNames)
    {
        $this->requiredPermissionNames = $requiredPermissionNames;
        return $this;
    }

    /**
     * @return array|string[]
     */
    public function getRequiredRoles()
    {
        return $this->requiredRoles;
    }

    /**
     * @param array|string[] $requiredRoles
     * @return MenuItem
     */
    public function setRequiredRoles($requiredRoles)
    {
        $this->requiredRoles = $requiredRoles;
        return $this;
    }

    /**
     * @return array
     */
    public function getAttributes(): array
    {
        return $this->attributes;
    }

    /**
     * @param array $attributes
     * @return MenuItem
     */
    public function setAttributes(array $attributes): MenuItem
    {
        $this->attributes = $attributes;
        return $this;
    }

    /**
     * @return ArrayList|MenuItem[]
     */
    public function getChilds()
    {
        return $this->childs;
    }

    /**
     * @param ArrayList|MenuItem[] $childs
     * @return MenuItem
     */
    public function setChilds($childs)
    {
        $this->childs = $childs;
        return $this;
    }

    /**
     * @return Menu|MenuItem|null
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * @param Menu|MenuItem|null $parent
     */
    public function setParent($parent): void
    {
        $this->parent = $parent;
    }

    #endregion properties

    #region Methods

    /**
     * @param string $roleSystemName
     * @return MenuItem
     */
    public function addRoleRequired(string $roleSystemName): MenuItem
    {
        $this->requiredRoles[] = $roleSystemName;
        return $this;
    }

    /**
     * @param string $permissionSystemName
     * @return MenuItem
     */
    public function addPermissionRequire(string $permissionSystemName): MenuItem
    {
        $this->requiredPermissionNames[] = $permissionSystemName;
        return $this;
    }

    /**
     * @param MenuItem $menuItem
     * @return MenuItem
     */
    public function addChild(MenuItem $menuItem): MenuItem
    {
        $menuItem->setParent($this);;
        $this->childs->add($menuItem);
        return $this;
    }

    /**
     * @param MenuItem $menuItem
     * @return bool
     */
    public function removeChild(MenuItem $menuItem):bool{
        return $this->childs->remove($menuItem);
    }


    /**
     * @param string $key
     * @param string $value
     * @return MenuItem
     */
    public function addAttribute(string $key, string $value): MenuItem
    {
        $this->attributes[$key] = $value;
        return $this;
    }

    /**
     * @return bool
     */
    public function hasChilds(): bool
    {
        return !empty($this->childs) && $this->childs->any();
    }

    /**
     * @return bool
     */
    public function hasPermissionRequire(): bool
    {
        return !empty($this->requiredPermissionNames);
    }

    /**
     * @return bool
     */
    public function hasRoleRequired(): bool
    {
        return !empty($this->requiredRoles);
    }

    /**
     * @return bool
     */
    public function hasAttributes(): bool
    {
        return !empty($this->attributes);
    }

    /**
     * @param string $systemName
     * @return bool
     */
    public function isActive(string $systemName): bool
    {
        if ($this->active !== null) {
            return $this->active;
        }
        if (empty($systemName)) {
            $this->active = false;
            return false;
        }
        $this->active = $this->getSystemName() == $systemName;
        if ($this->active == false && $this->hasChilds()) {
            foreach ($this->getChilds() as $child) {
                $res = $child->isActive($systemName);
                if ($res) {
                    $this->active = $res;
                    break;
                }
            }
        }
        return $this->active;
    }

    /**
     * @param string $systemName
     * @return MenuItem|null
     */
    public function findBySystemName(string $systemName):?MenuItem{
        if(empty($systemName)){
            return null;
        }
        if($this->getSystemName() == $systemName){
            return $this;
        }
        if($this->hasChilds()){
            foreach ($this->getChilds() as $child){
                $res = $child->findBySystemName($systemName);
                if(!empty($res)){
                    return $res;
                }
            }
        }
        return null;
    }

    public function deleteFromParent(){
        $parent = $this->getParent();
        if(!empty($parent)){
            if($parent instanceof Menu){
                $parent->removeMenuItem($this);
                $this->parent = null;
            }elseif ($parent instanceof MenuItem){
                $parent->removeChild($this);
                $this->parent = null;
            }
        }
    }


    public function findByUrl(string $url):?MenuItem{
        if(empty($url)){
            return null;
        }
        if(trim($this->getUrl(),"/") == trim("$url")){
            return $this;
        }
        if($this->hasChilds()){
            foreach ($this->getChilds() as $child){
                $res = $child->findByUrl($url);
                if(!empty($res)){
                    return $res;
                }
            }
        }
        return null;
    }

    #endregion Methods

}

class Menu
{

    #region field

    /**
     * @var ArrayList|MenuItem[]
     */
    protected ArrayList $menuItems;

    #endregion field

    #region ctor

    /**
     * Menu constructor.
     * @param array $menuItems
     */
    public function __construct(?array $menuItems = null)
    {
        $this->menuItems = new ArrayList();
        if(!empty($menuItems)){
            foreach ($menuItems as $menuItem) {
                $this->addMenuItem($menuItem);
            }
        }
    }

    #endregion ctor

    #region Properties

    /**
     * @return ArrayList|MenuItem[]
     */
    public function getMenuItems(): ArrayList
    {
        return $this->menuItems;
    }

    /**
     * @param array|MenuItem[] $menuItems
     * @return Menu
     */
    public function setMenuItems(array $menuItems): Menu
    {
        $this->menuItems = new ArrayList($menuItems);
        return $this;
    }

    #endregion Properties

    #region Methods

    public function addMenuItem(MenuItem $menuItem){
        $menuItem->setParent($this);
        $this->menuItems->add($menuItem);
    }

    /**
     * @param MenuItem $menuItem
     * @return bool
     */
    public function removeMenuItem(MenuItem $menuItem):bool {
        return $this->menuItems->remove($menuItem);
    }

    /**
     * @param string $systemName
     * @return MenuItem|null
     */
    public function findBySystemName(string $systemName):?MenuItem{
        if(empty($systemName)){
            return null;
        }

        foreach ($this->menuItems as $menuItem){
            $found = $menuItem->findBySystemName($systemName);
            if(!empty($found)){
                return $found;
            }
        }
        return null;
    }

    public function findByUrl(string $url):?MenuItem{
        if(empty($url)){
            return null;
        }

        foreach ($this->menuItems as $menuItem){
            $found = $menuItem->findByUrl($url);
            if(!empty($found)){
                return $found;
            }
        }
        return null;
    }


    #endregion Methods


}

class MenuManager
{


    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region Methods


    /**
     * @param string $xmlPath
     * @return Menu
     * @throws Exception
     */
    public function loadMenu(string $xmlPath):Menu
    {

        $xmlStr = file_get_contents($xmlPath);
        $root = new SimpleXMLElement($xmlStr);
        $menu = new Menu();
        foreach ($root->children() as $menuItem){
            $menu->addMenuItem($this->readMenuItem($menuItem));
        }
        return $menu;
    }

    #endregion Methods

    #region utils

    /**
     * @param SimpleXMLElement $element
     * @return MenuItem
     */
    protected function readMenuItem(SimpleXMLElement $element):MenuItem{
        $mi = new MenuItem();

        foreach ($element->attributes() as $key => $val){
            switch (strtolower($key)){
                case 'text':
                    $mi->setText($val);
                    break;
                case 'url':
                    $mi->setUrl($val);
                    break;
                case 'systemname':
                    $mi->setSystemName($val);
                    break;
                case 'iconclass':
                    $mi->setIconClass($val);
                    break;
                case 'loginrequired':
                    $mi->setLoginRequired((bool)$val);
                    break;
                case 'requiredpermissions':
                    $mi->setRequiredPermissionNames(explode(',',$val));
                    break;
                case 'requiredroles':
                    $mi->setRequiredRoles(explode(',',$val));
                    break;
                default:
                    $mi->addAttribute($key,$val);
                    break;
            }
        }

        foreach ($element->children() as $subMenuItem){
            $mi->addChild($this->readMenuItem($subMenuItem));
        }
        return $mi;
    }

    #endregion utils

}

$menuManager = new MenuManager();

$menuPath = 'C:\works\f1\kadir_eticaret\kadireticaret\writable\menus\Admin\mainmenu.config.xml';
$menuPath2 = 'C:\works\ibb\bahçe_market\bahcemarketyedek\bahcemarketyedek\writable\menus\Admin\mainmenu.config.xml';

$menu = $menuManager->loadMenu($menuPath);
$menu2 = $menuManager->loadMenu($menuPath2);





$ds = DIRECTORY_SEPARATOR;

$searchPath = 'C:\works\ibb\bahçe_market\bahcemarketyedek\bahcemarketyedek';
$searchPath = str_replace(['/','\\'],$ds,$searchPath) . $ds;

$routesFiles = \Gek\FileFinder\FileFinder::create(2)
    ->notPathFilter("writable",'public',"vendor")
    ->pathFilter("Config")
    ->nameFilter("Routes.php")
    ->onlyFiles()
    ->in($searchPath)
    ->asEnumerable()
    ->select(fn(FileInfo $fi)=> $fi->getRealPath())
    ->select(fn($i)=> file_get_contents($i))
    ->select(fn($i) => Enumerable::fromArray(explode(PHP_EOL,str_replace(['\r',"\n"],PHP_EOL,$i))))
    ->aggregate(fn(ArrayList $cur, $i) => $cur->addRange($i),new ArrayList())
    ->where(fn($i) => !empty(trim($i)))
    ->where(fn($i) => Str::startsWith(trim($i),'$routes->'))
    ->where(fn($i) => false == Str::contains($i,"Services::routes()") )
    ->where(fn($i) => false == Str::contains($i,"setDefaultController") )
    ->where(fn($i) => false == Str::contains($i,"setDefaultMethod") )
    ->where(fn($i) => false == Str::contains($i,"setTranslateURIDashes") )
    ->where(fn($i) => false == Str::contains($i,"set404Override") )
    ->where(fn($i) => false == Str::contains($i,"setAutoRoute") )
    ->distinct()
    ->select(fn($i) => str_replace('$routes->',"",$i))
    ->select(function ($i){
        $indx = Str::indexOf($i,"(");

        $method = substr($i,0,$indx);
        $twoArr = explode(",",substr($i,$indx));
        $route = $twoArr[0];
        $handler = str_replace(")","",$twoArr[1]);
        $method = trim(str_replace(["'",'"',"(",")",",",":"],"",$method));
        if(Str::toLowerCase($method) == 'add'){
            $method = 'all';
        }
        $route = trim(str_replace(["'",'"',",",";"],"",$route));
        $route = ltrim($route,"(");
        $handler = trim(str_replace(["'",'"',",",";"],"",$handler));
        $handlerArr = explode("::",$handler);
        $hCont = trim($handlerArr[0],"\\");
        $hMethod = isset($handlerArr[1]) ? $handlerArr[1] : "index";
        if(Str::contains($hMethod,"/")){
            $hMethod = (explode("/",$hMethod))[0];
        }
        return (object)[
            'route' => $route,
            'httpMethod' => $method,
            "controller" => $hCont,
            "method" => $hMethod,
        ];
    })->toGroupedArray(function ($i){
        try {
            $gKey = $i->controller;
            return $gKey;
        }catch (Throwable $exp){
            echo "Err.";
            var_dump($i);
            exit(0);
        }
    });

foreach ($routesFiles as $k => &$valArr){
    $valArr = Enumerable::fromArray($valArr)
        ->toGroupedArray(function ($i){
            return $i->method;
        });
    foreach ($valArr as $key => &$subArr ){
        $subArr = Enumerable::fromArray($subArr)
            ->toGroupedArray(function ($item){
                return $item->route;
            },function ($itm){
                return $itm->httpMethod;
            });
    }
}
file_put_contents("rtTest.txt",print_r($routesFiles,true));
//var_dump($routesFiles);
//var_dump(count($routesFiles));
$err = [];
foreach ($routesFiles as $clsName => $mthArr){
    $fileName = $searchPath . str_replace(["/","\\"],$ds,trim($clsName,"\\")) .".php";
    //var_dump($fileName);
    try {
        $refClass = CodeFactory::classCreateFromFile($fileName);
        foreach ($mthArr as $mthName => $routesArr){
            $refMethod = $refClass->getMethodByName($mthName);
            foreach ($routesArr as $route => $httpMethods){
                $str = $route;
                $str .=  " " . implode(
                    ",",
                    Enumerable::fromArray($httpMethods)
                        ->distinct()
                        ->toArray()
                    );
                $refMethod->getDocComment()->checkAndAddTag("route",$str);

                $mn = $menu->findByUrl($route);
                if(empty($mn)){
                    $mn = $menu2->findByUrl($route);
                }
                if(empty($mn)){
                    if($mthName == "add" ){
                        $refMethod->getDocComment()->checkAndAddTag("menu-ignore");
                    }
                    continue;
                }

                if(!empty($mn->getText())){
                    $refMethod->getDocComment()->checkAndAddTag("menu-name",$mn->getText());
                }
                if(!empty($mn->getSystemName())){
                    $refMethod->getDocComment()->checkAndAddTag("menu-system-name",$mn->getSystemName());
                }
                if(!empty($mn->getIconClass())){
                    $refMethod->getDocComment()->checkAndAddTag("menu-icon",$mn->getIconClass());
                }
                if(!empty($mn->getParent()) && ($mn->getParent() instanceof MenuItem) && !empty($mn->getParent()->getSystemName())){
                    $refMethod->getDocComment()->checkAndAddTag("menu-group",$mn->getParent()->getSystemName());
                }

                /*
                if(!empty($mn->getRequiredRoles())){
                    $refMethod->getDocComment()->checkAndAddTag("menu-roles",implode(",",$mn->getRequiredRoles()));
                }
                if(!empty($mn->getRequiredPermissionNames())){
                    $refMethod->getDocComment()->checkAndAddTag("menu-perms",implode(",",$mn->getRequiredPermissionNames()));
                }

                if(!empty($mn->isLoginRequired())){
                    $refMethod->getDocComment()->checkAndAddTag("menu-login-require");
                }
                */


            }
        }
        file_put_contents($fileName,"<?php " . PHP_EOL . $refClass->toIndentedString());
    }catch (Throwable $exp){
        $err[] = $fileName;
        $err[] = print_r($exp,true);
        $err[] = str_repeat("=",60);
    }

}
file_put_contents("err.txt",print_r($err,true));

exit(0);




$ds =  DIRECTORY_SEPARATOR;
$sampleFile  = __DIR__ . $ds ."DeliveryDatesController.php";

$res = CodeFactory::classCreateFromFile($sampleFile,"DeliveryDatesController");

$res->getMethodByName("list")
    ->addCommentTag("route","admin/test/list")
    ->addCommentTag("route-method","get")
    ->addCommentTag("menu.ignore");

var_dump($res);
$testFile  = __DIR__ . $ds ."DeliveryDatesControllerTedt.php";
file_put_contents($testFile, "<?php" . PHP_EOL . $res->toIndentedString());

exit(0);

//$sampleFile  = __DIR__ . $ds ."List.php";


$projectFiles = [new LocalFile($sampleFile)];

$projectFactory = ProjectFactory::createInstance();

/** @var \phpDocumentor\Reflection\Php\Project $project */
$project = $projectFactory->create("sample", $projectFiles);
$fileArr = $project->getFiles();
$fileArr = array_reverse($fileArr);
/** @var \phpDocumentor\Reflection\Php\File $refFile */
$refFile = array_pop($fileArr);

file_put_contents("testlog.txt",print_r($refFile->getDocBlock(),true));
foreach ($refFile->getNamespaces() as $k => $v){
    var_dump($v);
    var_dump($k);
}


exit(0);

$fileTest = new \Gek\PhpLang\PhpFile('');
$fileTest->addContent('use CodeIgniter\Router\RouteCollection;')
    ->addContent('/** @var RouteCollection $routes */')
    ->addContent('')
    ->addContent(
        "// \$routes->get('sample/uri', 'App\Controllers\SampleController::sampleMethod');"
    );
echo $fileTest->toIndentedString();
exit(0);

$test = CodeFactory::classCreate('ClassMethod')
    ->setNamespace("Gek\\PhpLang")
    ->setExtends(ClassMember::class)
    ->addImplement(IToIndentedString::class)
    ->addImplement(IUseCreator::class);
$test->addTrait(StaticAware::class)
    ->addTrait(AbstractAware::class)
    ->addTrait(FinalAware::class)
    ->addUse(PhpVisibility::class)
    ->addUse(UseItem::class)
    ->addUse('Memo\\Code\\MethodParamCollection');

$test->addProperty('interfaceMethod', 'bool',true,false)
    ->setValue('false');




$test->addField('interfaceMethod', 'bool')
    ->setVisibility(PhpVisibility::PROTECTED())
    ->setValue('false')
    ->setRegion('fields')
    ->autoDocComment();

//field
$test->addField('returnType', '?' . PhpTypeDeclared::class)
    ->setVisibility(PhpVisibility::PROTECTED())
    ->setValue('null')
    ->setRegion('fields')
    ->autoDocComment();

$test->addField('params', MethodParamCollection::class)
    ->setVisibility(PhpVisibility::PROTECTED())
    ->setRegion('fields')
    ->autoDocComment();

$test->addField('codeLines', CodeLineCollection::class)
    ->setVisibility(PhpVisibility::PROTECTED())
    ->setRegion('fields')
    ->autoDocComment();

// ctor
$ctor = $test->addConstructor(true)
    ->addParams('string $name, ?PhpVisibility $visibility = null')
    ->setBody('parent::__construct($name, $visibility);
$this->params = new MethodParamCollection();
$this->codeLines = new CodeLineCollection();')
    ->autoDocComment();


// Properties
$test->addMethod('setInterfaceMethod')
    ->addParams('bool $interfaceMethod = true')
    ->setReturnType('self')
    ->setBody('$this->interfaceMethod = $interfaceMethod;
return $this;')
    ->setRegion('Properties')
    ->autoDocComment();

$test->addMethod('getReturnType')
    ->setReturnType('?string')
    ->setBody('return $this->returnType !== null ? $this->returnType->getRaw() : null;')
    ->setRegion('Properties')
    ->autoDocComment();

$test->addMethod('setReturnType')
    ->addParams('PhpTypeDeclared|array|string|null $returnType')
    ->setReturnType('self')
    ->setBody('if (is_array($returnType)) {
    $temp = array();
    foreach ($returnType as $tp) {
        if ($tp === null) {
            $tp = \'null\'; 
        }
        if (empty($tp)) {
            continue;
        }
        $temp[] = $tp;
    }
    $returnType = implode(\'|\', $temp);
}
if (is_string($returnType)) {
    $returnType = new PhpTypeDeclared($returnType);
}
$this->returnType = $returnType;
return $this;')
    ->setRegion('Properties')
    ->autoDocComment()
    ->addCommentTag('throws', '\Gek\Infrastructure\Exceptions\GekException')
    ->addCommentTag('throws', '\ReflectionException');

$test->addMethod('getParams')
    ->setReturnType(MethodParamCollection::class)
    ->setBody('return $this->params;')
    ->setRegion('Properties')
    ->autoDocComment();

$test->addMethod('setParams')
    ->addParams('MethodParamCollection $params')
    ->setReturnType('self')
    ->setBody('$this->params = $params;
    return $this;')
    ->setRegion('Properties')
    ->autoDocComment();

$test->addMethod('getCodeLines')
    ->setReturnType(CodeLineCollection::class)
    ->setBody('return $this->codeLines;')
    ->setRegion('Properties')
    ->autoDocComment();

$test->addMethod('setCodeLines')
    ->addParams('CodeLineCollection $codeLines')
    ->setReturnType('self')
    ->setBody('$this->codeLines = $codeLines;
    return $this;')
    ->setRegion('Properties')
    ->autoDocComment();

$test->addMethod('getBody')
    ->setReturnType('string')
    ->setBody('return strval($this->codeLines);')
    ->setRegion('Properties')
    ->autoDocComment();

$test->addMethod('setBody')
    ->addParams('string $codes')
    ->setReturnType('self')
    ->setBody('$this->codeLines->clear();
    $this->codeLines->addCodes($codes);
    return $this;')
    ->setRegion('Properties')
    ->autoDocComment();

// Methods

$test->addMethod('isInterfaceMethod')
    ->setReturnType('bool')
    ->setBody('return $this->interfaceMethod;')
    ->setRegion('Methods')
    ->autoDocComment();

$test->addMethod('hasParams')
    ->setReturnType('bool')
    ->setBody('$this->params->any();')
    ->setRegion('Methods')
    ->autoDocComment();

$test->addMethod('addParam')
    ->addParams(MethodParam::class . '|string $param, ?string $type = null, ?string $val = null, ?int $renderType = null')
    ->setReturnType('self')
    ->setBody('$this->params->addParam($param, $type, $val, $renderType);
    return $this;')
    ->setRegion('Methods')
    ->autoDocComment()
    ->addCommentTag('throws', '\ReflectionException')
    ->addCommentTag('throws', '\Gek\Infrastructure\Exceptions\GekException');

$test->addMethod('addParams')
    ->addParams('string $params')
    ->setReturnType('self')
    ->setBody('$this->params->addParams($params);
    return $this;')
    ->setRegion('Methods')
    ->autoDocComment()
    ->addCommentTag('throws', '\ReflectionException')
    ->addCommentTag('throws', '\Gek\Infrastructure\Exceptions\GekException');

$test->addMethod('addCodeLine')
    ->addParams(CodeLine::class . '|string $code, int $indentLevel = 0')
    ->setReturnType('self')
    ->setBody('$this->codeLines->addCodeLine($code, $indentLevel);
    return $this;')
    ->setRegion('Methods')
    ->autoDocComment();

$test->addMethod('addCodeLines')
    ->addParams('string $code')
    ->setReturnType('self')
    ->setBody('$this->codeLines->addCodes($code);
    return $this;')
    ->setRegion('Methods')
    ->autoDocComment();

$test->addMethod('hasBody')
    ->setReturnType('bool')
    ->setBody('return $this->codeLines->any();')
    ->setRegion('Methods')
    ->autoDocComment();

$test->addMethod('hasReturnType')
    ->setReturnType('bool')
    ->setBody('return $this->getReturnType() !== null;')
    ->setRegion('Methods')
    ->autoDocComment();

$test->addMethod('autoDocComment')
    ->setReturnType('self')
    ->setBody('$this->getDocComment()->getTags()->clear();
if ($this->params->any()) {
    foreach ($this->params as $prm) {
        $this->addCommentTag(\'param\', $prm->renderForComment());
    }
}
if ($this->hasReturnType()) {
    $this->addCommentTag(\'return\', $this->returnType->renderForComment());
}
return $this;')
    ->setRegion('Methods')
    ->autoDocComment();

$test->addMethod('__toString')
    ->setBody('return $this->toIndentedString();')
    ->setRegion('Methods');

// IToIndentedString
$test->addMethod('toIndentedString')
    ->addParams('int $indentLevel = 0,string $indentChars = \'    \'')
    ->setReturnType('string')
    ->setBody('$indent = str_repeat($indentChars, $indentLevel);

$strRes = \'\';
if(!$this->getDocComment()->isEmpty()){
    $strRes .= $this->getDocComment()->toIndentedString($indentLevel,$indentChars);
}

$strRes .= $indent . $this->visibility->getValue() . " ";
if ($this->isAbstract()) {
    $strRes .= \'abstract \';
} elseif ($this->isFinal()) {
    $strRes .= \'final \';
}
if ($this->isStatic()) {
    $strRes .= \'static \';
}
$strRes .= \'function \'.  $this->getName();
$strRes .= \'(\' . $this->params . ")";
if ($this->hasReturnType()) {
    $retType = $this->returnType->renderForReturn();
    if(!empty($retType)){
        $strRes .= \':\' . $retType . " ";
    }
}

if ($this->isInterfaceMethod() || $this->isAbstract()) {
    $strRes .= \';\';
} else {
    $strRes .= \'{\' . PHP_EOL;

    if ($this->hasBody()) {
        /** @var CodeLineCollection $lines */
        $lines = $this->codeLines->select(function (CodeLine $item) {
            $item->incrementIndentLevel();
            return $item;
            })->toTypedClass(CodeLineCollection::class);
        $strRes .= $lines->toIndentedString($indentLevel,$indentChars);
    }
    $strRes .= $indent . \'}\' . PHP_EOL;

}

return $strRes;')
    ->setRegion('IToIndentedString')
    ->autoDocComment();

$test->addMethod('getUseArray')
    ->setReturnType('array')
    ->setBody('$useArr  = $this->params->getUseArray();
if($this->hasReturnType()){
    $useArr = array_merge($useArr, $this->returnType->getUseArray());
}
return $useArr;')
    ->addCommentTag('return', 'array|UseItem[]')
    ->setRegion('IUseCreator');

$phpFile = new \Gek\PhpLang\PhpFile();
$phpFile->addContent(new CodeLine('// dosya başı.'));
$phpFile->addContent($test);
$phpFile->addContent(new CodeLine('// dosya sonu.'));


echo $phpFile->toIndentedString();

exit(0);
$test = implode('|', [
    Traversable::class,
    'array',
    'iterable',
    Iterator::class,
    Generator::class,
    'self',
    IteratorAggregate::class,
    'null',
    ArrayList::class,
    Enumerable::class,
    \Gek\Collections\ICollection::class,

]);
$method = new \Gek\PhpLang\ClassMethod('calculate', PhpVisibility::PRIVATE());
$method->setBody('return md5($password);')
    ->setReturnType($test)
    ->addParams('string|int|float $password = \'5\' ')
    ->autoDocComment();
var_dump($method->toIndentedString(3));
var_dump(Enumerable::fromArray($method->getUseArray())->select(function ($i) {
    return $i . '';
})->toArray());
exit(0);

$field = new \Gek\PhpLang\ClassField('name', '?string', PhpVisibility::PROTECTED());
$field->setValue('null');
$field->autoDocComment();
var_dump($field->toIndentedString('    ', 1));
exit(0);

$test = implode('|', [
    Traversable::class,
    'array',
    'iterable',
    Iterator::class,
    Generator::class,
    'self',
    IteratorAggregate::class,
    'null',
    ArrayList::class,
    Enumerable::class,
    \Gek\Collections\ICollection::class,

]);
$td = new PhpTypeDeclared($test);
var_dump($td->renderForComment());
var_dump($td->renderForField());
var_dump(implode(PHP_EOL, $td->getUseItems()));

exit(0);

$m = new \Gek\PhpLang\ClassMethod("test", PhpVisibility::PROTECTED());
$m->setReturnType('self')
    ->setFinal()
    ->addParams('string $type, bool $isNew = false')
    ->addCodeLines('$this->type = $type;')
    ->addCodeLines('$this->new = $isNew;')
    ->addCodeLines('return $this;');

var_dump($m . '');
exit(0);

$clList = new CodeLineCollection();
$raw = <<<EOD
\$indent = '';
        \$resStr = \$indent . "/**" . PHP_EOL;
        \$resStr .= \$indent ." * " . \$this->getSummary();
        \$resStr .= \$indent . " * " . PHP_EOL;
        if(\$this->description != null){
            \$lines = explode(PHP_EOL,\$this->description);
            foreach (\$lines as \$line){
                \$resStr .= \$indent . " * " . \$line . PHP_EOL;
            }
            \$resStr .= \$indent . " * " . PHP_EOL;
        }
        if(\$this->tags->any()){
            foreach (\$this->tags as \$k => \$v){
                \$resStr .= Str::format("{0} * @{1} {2}{3}",\$indent, \$k, \$v, PHP_EOL);
            }
            \$resStr .= \$indent . " * " . PHP_EOL;
        }
        \$resStr .= \$indent . " */ " . PHP_EOL;

        return \$resStr;
EOD;
$clList->addCodes('$indent = \'\';');
$clList->addCodes('$indent = \'\';');
$clList->addCodes("    \$lines = explode(PHP_EOL,\$this->description);");


var_dump($clList . '');


