---
title: \Gek\PhpLang\PhpTypeDeclared
footer: false
---

# PhpTypeDeclared

PhpTypeDeclared sınıfı

Php tür bildirimi sınıfı

örnek: [PhpTypeDeclared](../../../examples/Gek/PhpLang/PhpTypeDeclared_class/index.md)


* Full name (Tam Adı): `\Gek\PhpLang\PhpTypeDeclared`
* Bu sınıf şu arayüzleri (interface) uygular:  \Gek\PhpLang\Contracts\IUseCreator, \Serializable

**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpTypeDeclared_class/index.md)



## Constants (Sabitler)

| Constant | Type | Value |
|:---      |:---  |:---   |
|`\Gek\PhpLang\PhpTypeDeclared::ALL_USE`||\Gek\PhpLang\TypeUsage::FIELD_USE | \Gek\PhpLang\TypeUsage::RETURN_USE | \Gek\PhpLang\TypeUsage::PARAM_USE | \Gek\PhpLang\TypeUsage::COMMENT_USE|
|`\Gek\PhpLang\PhpTypeDeclared::PHP_TYPES_USAGES`||[
    // SCALAR_TYPES
    &#039;bool&#039; =&gt; \Gek\PhpLang\TypeUsage::ALL,
    &#039;boolean&#039; =&gt; \Gek\PhpLang\TypeUsage::COMMENT_USE,
    &#039;int&#039; =&gt; \Gek\PhpLang\TypeUsage::ALL,
    &#039;integer&#039; =&gt; \Gek\PhpLang\TypeUsage::COMMENT_USE,
    &#039;float&#039; =&gt; \Gek\PhpLang\TypeUsage::ALL,
    &#039;double&#039; =&gt; \Gek\PhpLang\TypeUsage::COMMENT_USE,
    &#039;string&#039; =&gt; \Gek\PhpLang\TypeUsage::ALL,
    //COMPOUND_TYPES
    &#039;array&#039; =&gt; \Gek\PhpLang\TypeUsage::ALL,
    &#039;object&#039; =&gt; \Gek\PhpLang\TypeUsage::ALL,
    &#039;callable&#039; =&gt; \Gek\PhpLang\TypeUsage::ALL ^ \Gek\PhpLang\TypeUsage::FIELD_USE,
    &#039;iterable&#039; =&gt; \Gek\PhpLang\TypeUsage::ALL,
    //SPECIAL_TYPES
    &#039;resource&#039; =&gt; \Gek\PhpLang\TypeUsage::COMMENT_USE,
    &#039;null&#039; =&gt; \Gek\PhpLang\TypeUsage::COMMENT_USE,
    //PSEUDO_TYPES
    &#039;mixed&#039; =&gt; \Gek\PhpLang\TypeUsage::COMMENT_USE,
    &#039;number&#039; =&gt; \Gek\PhpLang\TypeUsage::COMMENT_USE,
    &#039;callback&#039; =&gt; \Gek\PhpLang\TypeUsage::COMMENT_USE,
    &#039;void&#039; =&gt; \Gek\PhpLang\TypeUsage::RETURN_USE | \Gek\PhpLang\TypeUsage::COMMENT_USE,
    //LATE STATİC BINDINGS
    &#039;self&#039; =&gt; \Gek\PhpLang\TypeUsage::ALL,
    &#039;parent&#039; =&gt; \Gek\PhpLang\TypeUsage::ALL,
    &#039;static&#039; =&gt; \Gek\PhpLang\TypeUsage::COMMENT_USE,
]|
|`\Gek\PhpLang\PhpTypeDeclared::TYPE_MAP`||[&#039;boolean&#039; =&gt; &#039;bool&#039;, &#039;integer&#039; =&gt; &#039;int&#039;, &#039;double&#039; =&gt; &#039;float&#039;, &#039;callback&#039; =&gt; &#039;callable&#039;]|

## Methods (Yöntemler)

### __construct

PapTypeDeclared yapıcı metod.

```php
public PhpTypeDeclared::__construct(string $types): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `types` | **string** | tür bildirim ifadesi |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpTypeDeclared_class/__construct_method.md)


---
### getRaw

ham tğr bildirimini verir.

```php
public PhpTypeDeclared::getRaw(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpTypeDeclared_class/getRaw_method.md)


---
### getTypes

bildirim türlerini verir.

```php
public PhpTypeDeclared::getTypes(): \Gek\Collections\ArrayList|\Gek\PhpLang\PhpType[]|array
```









**Return Value (Dönüş değeri):**


\Gek\Collections\ArrayList|\Gek\PhpLang\PhpType[]|array



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpTypeDeclared_class/getTypes_method.md)


---
### isNullable

nullable mi ?

```php
public PhpTypeDeclared::isNullable(): bool
```









**Return Value (Dönüş değeri):**

nullable ise true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpTypeDeclared_class/isNullable_method.md)


---
### renderForUsage

kullanılan yere göre bildirimi render eder.

```php
public PhpTypeDeclared::renderForUsage(\Gek\PhpLang\TypeUsage $usage): string
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `usage` | **\Gek\PhpLang\TypeUsage** | kullanılan yer |


**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpTypeDeclared_class/renderForUsage_method.md)


---
### renderForField

sınıf özelliği (property) için render eder.

```php
public PhpTypeDeclared::renderForField(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpTypeDeclared_class/renderForField_method.md)


---
### renderForReturn

metod dönüş türü için render eder

```php
public PhpTypeDeclared::renderForReturn(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpTypeDeclared_class/renderForReturn_method.md)


---
### renderForParam

parametre ,türü için render eder.

```php
public PhpTypeDeclared::renderForParam(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpTypeDeclared_class/renderForParam_method.md)


---
### renderForComment

doc comment için render eder.

```php
public PhpTypeDeclared::renderForComment(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpTypeDeclared_class/renderForComment_method.md)


---
### getUseArray

tür importlarını verir.

```php
public PhpTypeDeclared::getUseArray(): array|\Gek\PhpLang\UseItem[]
```









**Return Value (Dönüş değeri):**


array|\Gek\PhpLang\UseItem[]



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpTypeDeclared_class/getUseArray_method.md)


---
### serialize

String representation of object

```php
public PhpTypeDeclared::serialize(): string
```









**Return Value (Dönüş değeri):**

the string representation of the object or null
string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpTypeDeclared_class/serialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.serialize.php - 


---
### unserialize

Constructs the object

```php
public PhpTypeDeclared::unserialize(string $serialized): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `serialized` | **string** | &lt;p&gt;<br />The string representation of the object.<br />&lt;/p&gt; |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/PhpTypeDeclared_class/unserialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.unserialize.php - 


---


---
> 2022-04-15 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
