---
title: \Gek\PhpLang\Collections\PhpTypeCollection
footer: false
---

# PhpTypeCollection

PhpTypeCollection Sınıfı

Php tip (tür) koleksiyonu

örnek: [PhpTypeCollection](../../../../examples/Gek/PhpLang/Collections/PhpTypeCollection_class/index.md)


* Full name (Tam Adı): `\Gek\PhpLang\Collections\PhpTypeCollection`
* Parent class (Üst Sınıf): [TypedListWrapper](../../../../classes.md)
* Bu sınıf şu arayüzleri (interface) uygular:  \Gek\PhpLang\Contracts\IUseCreator, \Serializable

**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/PhpTypeCollection_class/index.md)



## Methods (Yöntemler)

### __construct

PhpTypeCollection yapıcı metod.

```php
public PhpTypeCollection::__construct(\Gek\PhpLang\PhpType $items): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `items` | **\Gek\PhpLang\PhpType** | (opsiyonel) öğeler. |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/PhpTypeCollection_class/__construct_method.md)


---
### add

öğe ekler.

```php
public PhpTypeCollection::add(\Gek\PhpLang\PhpType $item): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\PhpType** | öğe |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/PhpTypeCollection_class/add_method.md)


---
### addRange

çoklu öğe ekler.

```php
public PhpTypeCollection::addRange(\Gek\PhpLang\PhpType $items): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `items` | **\Gek\PhpLang\PhpType** | öğeler |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/PhpTypeCollection_class/addRange_method.md)


---
### contains

öğenin koleksiyonda olup olmadığına bakar.

```php
public PhpTypeCollection::contains(\Gek\PhpLang\PhpType $item): bool
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\PhpType** | öğe |


**Return Value (Dönüş değeri):**

varsa true yoksa false
bool



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/PhpTypeCollection_class/contains_method.md)


---
### remove

öğeyi koleksiyonda kaldırır.

```php
public PhpTypeCollection::remove(\Gek\PhpLang\PhpType $item): bool
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\PhpType** | öğe |


**Return Value (Dönüş değeri):**

başarı durumunda true aksi halde false
bool



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/PhpTypeCollection_class/remove_method.md)


---
### indexOf

verilen öğenin koleksiyondaki indeksini verir.

```php
public PhpTypeCollection::indexOf(\Gek\PhpLang\PhpType $item): int
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\PhpType** | öğe |


**Return Value (Dönüş değeri):**

öğenin indeksi, öğe bulunamazsa -1
int



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/PhpTypeCollection_class/indexOf_method.md)


---
### insert

verilen indekse öğeyi ekler.

```php
public PhpTypeCollection::insert(int $index, \Gek\PhpLang\PhpType $item): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |
| `item` | **\Gek\PhpLang\PhpType** | öğe |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/PhpTypeCollection_class/insert_method.md)


---
### getAt

verilen indeksteki öğeyi verir.

```php
public PhpTypeCollection::getAt(int $index): \Gek\PhpLang\PhpType
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |


**Return Value (Dönüş değeri):**

öğe
\Gek\PhpLang\PhpType



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/PhpTypeCollection_class/getAt_method.md)


---
### setAt

verilen indekse öğeyi set eder.

```php
public PhpTypeCollection::setAt(int $index, \Gek\PhpLang\PhpType $item): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |
| `item` | **\Gek\PhpLang\PhpType** | öğe |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/PhpTypeCollection_class/setAt_method.md)


---
### insertRange

verilen indekse çoklu öğe ekler.

```php
public PhpTypeCollection::insertRange(int $index, \Gek\PhpLang\PhpType $items): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |
| `items` | **\Gek\PhpLang\PhpType** | öğeler |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/PhpTypeCollection_class/insertRange_method.md)


---
### getUseArray

koleksiyondaki türleri verir

```php
public PhpTypeCollection::getUseArray(): array|\Gek\PhpLang\UseItem[]
```









**Return Value (Dönüş değeri):**


array|\Gek\PhpLang\UseItem[]



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/PhpTypeCollection_class/getUseArray_method.md)


---
### serialize

String representation of object

```php
public PhpTypeCollection::serialize(): string
```









**Return Value (Dönüş değeri):**

the string representation of the object or null
string



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/PhpTypeCollection_class/serialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.serialize.php - 


---
### unserialize

Constructs the object

```php
public PhpTypeCollection::unserialize(string $serialized): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `serialized` | **string** | &lt;p&gt;<br />The string representation of the object.<br />&lt;/p&gt; |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/PhpTypeCollection_class/unserialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.unserialize.php - 


---


---
> 2022-04-15 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
