---
title: \Gek\PhpLang\Collections\CodeLineCollection
footer: false
---

# CodeLineCollection

CodeLineCollection sınıfı

Kod satırı koleksiyonu

örnek: [CodeLineCollection](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/index.md)


* Full name (Tam Adı): `\Gek\PhpLang\Collections\CodeLineCollection`
* Parent class (Üst Sınıf): [TypedListWrapper](../../../../classes.md)
* Bu sınıf şu arayüzleri (interface) uygular:  \Gek\PhpLang\Contracts\IToIndentedString, \Serializable

**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/index.md)



## Methods (Yöntemler)

### __construct

CodeLineCollection yapıcı method.

```php
public CodeLineCollection::__construct(\Gek\PhpLang\CodeLine $items): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `items` | **\Gek\PhpLang\CodeLine** | kode satırları |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/__construct_method.md)


---
### add

Kod satırı ekler

```php
public CodeLineCollection::add(\Gek\PhpLang\CodeLine $item): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\CodeLine** | kod satırı |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/add_method.md)


---
### addRange

çoklu kod satırı ekler

```php
public CodeLineCollection::addRange(\Gek\PhpLang\CodeLine $items): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `items` | **\Gek\PhpLang\CodeLine** | kod satırları |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/addRange_method.md)


---
### contains

Kod satırının koleksiyonda olup olmadığına bakar

```php
public CodeLineCollection::contains(\Gek\PhpLang\CodeLine $item): bool
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\CodeLine** | kod satırı |


**Return Value (Dönüş değeri):**

varsa true yoksa false
bool



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/contains_method.md)


---
### remove

verilen kod satırını koleksiyondan kaldırır

```php
public CodeLineCollection::remove(\Gek\PhpLang\CodeLine $item): bool
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\CodeLine** | kod satırı |


**Return Value (Dönüş değeri):**

başarılı durumda true aksi halde false
bool



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/remove_method.md)


---
### indexOf

Verilen kod satırının koleksiyondaki indeksini verir.

```php
public CodeLineCollection::indexOf(\Gek\PhpLang\CodeLine $item): int
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `item` | **\Gek\PhpLang\CodeLine** | kod satırı |


**Return Value (Dönüş değeri):**

indeks kod satırı bulunamazsa -1 döner
int



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/indexOf_method.md)


---
### insert

kod satırını verilen indekse ekler.

```php
public CodeLineCollection::insert(int $index, \Gek\PhpLang\CodeLine $item): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |
| `item` | **\Gek\PhpLang\CodeLine** | kod satırı |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/insert_method.md)


---
### getAt

verilen indeksteki kod satırını verir.

```php
public CodeLineCollection::getAt(int $index): \Gek\PhpLang\CodeLine
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |


**Return Value (Dönüş değeri):**

kod satırı
\Gek\PhpLang\CodeLine



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/getAt_method.md)


---
### setAt

verilen indekse kod satırını set eder.

```php
public CodeLineCollection::setAt(int $index, \Gek\PhpLang\CodeLine $item): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |
| `item` | **\Gek\PhpLang\CodeLine** | kod satırı |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/setAt_method.md)


---
### insertRange

verilen indekse çoklu kod satırlarını ekler.

```php
public CodeLineCollection::insertRange(int $index, \Gek\PhpLang\CodeLine $items): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `index` | **int** | indeks |
| `items` | **\Gek\PhpLang\CodeLine** | Kod satırları |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/insertRange_method.md)


---
### addCodeLine

kod satırı ekler

```php
public CodeLineCollection::addCodeLine(\Gek\PhpLang\CodeLine|string $code, int $indentLevel): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `code` | **\Gek\PhpLang\CodeLine|string** | kod satırı veya metin |
| `indentLevel` | **int** | girinti düzeyi |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/addCodeLine_method.md)


---
### addCodes



```php
public CodeLineCollection::addCodes(string $codes): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `codes` | **string** |  |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/addCodes_method.md)


---
### __toString



```php
public CodeLineCollection::__toString(): mixed
```









**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/__toString_method.md)


---
### toIndentedString

Girintili metin

```php
public CodeLineCollection::toIndentedString(int $indentLevel, string $indentChars = &#039;    &#039;): string
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `indentLevel` | **int** |  |
| `indentChars` | **string** |  |


**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/toIndentedString_method.md)


---
### serialize

String representation of object

```php
public CodeLineCollection::serialize(): string
```









**Return Value (Dönüş değeri):**

the string representation of the object or null
string



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/serialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.serialize.php - 


---
### unserialize

Constructs the object

```php
public CodeLineCollection::unserialize(string $serialized): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `serialized` | **string** | &lt;p&gt;<br />The string representation of the object.<br />&lt;/p&gt; |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../../examples/Gek/PhpLang/Collections/CodeLineCollection_class/unserialize_method.md)

**Ayrıca bakınız:**

* https://php.net/manual/en/serializable.unserialize.php - 


---


---
> 2022-04-15 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
