---
title: \Gek\PhpLang\CodeFactory
footer: false
---

# CodeFactory

CodeFactory sınıfı

Kod fabrikası

örnek: [CodeFactory](../../../examples/Gek/PhpLang/CodeFactory_class/index.md)


* Full name (Tam Adı): `\Gek\PhpLang\CodeFactory`

**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeFactory_class/index.md)



## Methods (Yöntemler)

### classCreate

Yeni bir sınıf oluşturur.

```php
public static CodeFactory::classCreate(string $name): \Gek\PhpLang\PhpClass
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | sınıf adı |


**Return Value (Dönüş değeri):**


\Gek\PhpLang\PhpClass



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeFactory_class/classCreate_method.md)


---
### createFromReflection

Verilen reflectionu kullanarak yeni bir sınıf oluşturur.

```php
public static CodeFactory::createFromReflection(\ReflectionClass $reflectedClass, bool $forceNonUserClass = false, bool $forceUseReflect = false): \Gek\PhpLang\PhpClass
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `reflectedClass` | **\ReflectionClass** | yansıtılmış sınıf |
| `forceNonUserClass` | **bool** | kullanıcı tanımlı olmayan sınıf olsa bile oluşturmak için zorla |
| `forceUseReflect` | **bool** | kaynak dosya olsa bile oluşturma işleminde sadece yansımayı kullanmak için zorla |


**Return Value (Dönüş değeri):**

sınıf
\Gek\PhpLang\PhpClass



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeFactory_class/createFromReflection_method.md)


---
### classCreateFromFile

kaynak kod dosyasında yeni bir sınıf oluştur.

```php
public static CodeFactory::classCreateFromFile(string $filePath, string|null $className = null): \Gek\PhpLang\PhpClass
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `filePath` | **string** | dosya yolu |
| `className` | **string|null** | sınıf adı |


**Return Value (Dönüş değeri):**

sınıf
\Gek\PhpLang\PhpClass



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeFactory_class/classCreateFromFile_method.md)


---
### traitCreateFromFile

kaynak kod dosyasında yeni bir trait oluştur.

```php
public static CodeFactory::traitCreateFromFile(string $filePath, string|null $className = null): \Gek\PhpLang\PhpClass
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `filePath` | **string** | dosya yolu |
| `className` | **string|null** | trait adı |


**Return Value (Dönüş değeri):**

trait
\Gek\PhpLang\PhpClass



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeFactory_class/traitCreateFromFile_method.md)


---
### interfaceCreateFromFile

kaynak kod dosyasında yeni bir arayüz oluştur.

```php
public static CodeFactory::interfaceCreateFromFile(string $filePath, string|null $className = null): \Gek\PhpLang\PhpClass
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `filePath` | **string** | dosya yolu |
| `className` | **string|null** | arayüz adı |


**Return Value (Dönüş değeri):**

arayüz
\Gek\PhpLang\PhpClass



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeFactory_class/interfaceCreateFromFile_method.md)


---
### interfaceCreate

yeni bir arayüz oluştur.

```php
public static CodeFactory::interfaceCreate(string $name): \Gek\PhpLang\PhpClass
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | arayüz adı |


**Return Value (Dönüş değeri):**

arayüz
\Gek\PhpLang\PhpClass



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeFactory_class/interfaceCreate_method.md)


---
### traitCreate

yeni bir trait oluştur.

```php
public static CodeFactory::traitCreate(string $name): \Gek\PhpLang\PhpClass
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | trait adı |


**Return Value (Dönüş değeri):**

trait
\Gek\PhpLang\PhpClass



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeFactory_class/traitCreate_method.md)


---
### fileCreate

yeni bir php dopsyası oluştur

```php
public static CodeFactory::fileCreate(string|null $namespace = null): \Gek\PhpLang\PhpFile
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `namespace` | **string|null** | ad alanı |


**Return Value (Dönüş değeri):**

php dosysdı
\Gek\PhpLang\PhpFile



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeFactory_class/fileCreate_method.md)


---
### create

PhpClass oluşturur.

```php
protected static CodeFactory::create(string $name, \Gek\PhpLang\ClassTypes|null $classType = null): \Gek\PhpLang\PhpClass
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **string** | sınıf adı |
| `classType` | **\Gek\PhpLang\ClassTypes|null** | sınıf tipi |


**Return Value (Dönüş değeri):**


\Gek\PhpLang\PhpClass



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeFactory_class/create_method.md)


---
### convertDocComment

DocBlock objesini  DocComment objesine çevirir.

```php
protected static CodeFactory::convertDocComment(\phpDocumentor\Reflection\DocBlock $docBlock): \Gek\PhpLang\DocComments\DocComment
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `docBlock` | **\phpDocumentor\Reflection\DocBlock** |  |


**Return Value (Dönüş değeri):**


\Gek\PhpLang\DocComments\DocComment



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeFactory_class/convertDocComment_method.md)


---
### getRegions

Kaynak kod satırı listesinden region bildirimlerini ayrıştırır.

```php
protected static CodeFactory::getRegions(\Gek\Collections\ArrayList $content, int $startLine): \Gek\Collections\ArrayList
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `content` | **\Gek\Collections\ArrayList** | kaynak kod satır listesi |
| `startLine` | **int** | kaynak kodun php dosyasındaki başlangıç satırı numarası |


**Return Value (Dönüş değeri):**

region bildirimleri dizisi
\Gek\Collections\ArrayList



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeFactory_class/getRegions_method.md)


---
### valueToLiteral

verilen değeri php literaline çevirir.

```php
protected static CodeFactory::valueToLiteral(mixed $value): string
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `value` | **mixed** | değer |


**Return Value (Dönüş değeri):**

php kodu
string



**Kullanım:** [örnek](../../../examples/Gek/PhpLang/CodeFactory_class/valueToLiteral_method.md)


---


---
> 2022-04-15 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
