<?php

use Gek\Collections\ArrayList;
use Gek\Collections\Enumerable;
use Gek\FileFinder\FileFinder;
use Gek\FileFinder\FileInfo;
use Gek\Filesystem\Filesystem;

include_once __DIR__ .DIRECTORY_SEPARATOR . "vendor/autoload.php";

$src = 'C:\tools\mpgh\mpgh\dts\inc\data';
$files = FileFinder::create()
    ->onlyFiles()
    ->in($src)
    ->asEnumerable()
    ->toGroupedArray(fn(FileInfo $fi) => $fi->getSize() . "");
$files = Enumerable::fromArray($files)
    ->where(fn(array $f) => count($f) > 1)
    ->toArray(true);
$hashArr = array();
foreach ($files as $size => $flArr) {
    /** @var FileInfo $filePath */
    foreach ($flArr as $filePath) {
        $h = hash_file('md5', $filePath->getRealPath());
        if (!isset($hashArr[$h])) {
            $hashArr[$h] = array();
        }
        $hashArr[$h][] = $filePath;
    }
}
$totalsize = 0;
$deleteSize = 0;
$deleteFileArr = new ArrayList();
$kalanSize = 0;
foreach ($hashArr as $fileArr) {
    $cArr = Enumerable::fromArray($fileArr)
        ->orderByDesc(fn(FileInfo $fi) => $fi->getFilename())
        ->toArray();
    $totalsize += Enumerable::fromArray($cArr)
        ->sum(fn(FileInfo $fi) => $fi->getSize());
    $first = array_shift($cArr);
    $kalanSize += $first->getSize();
    $deleteSize += Enumerable::fromArray($cArr)
        ->sum(fn(FileInfo $fi) => $fi->getSize());
    $deleteFileArr->addRange($cArr);
}

$deleteFileArr = $deleteFileArr
    ->select(fn(FileInfo $fi) => $fi->getRealPath())
    ->toArray();

$fs = new Filesystem();
$fs->removeAll($deleteFileArr);


var_dump($deleteFileArr);
var_dump(count($deleteFileArr));
var_dump($deleteSize);
var_dump($deleteSize / 1024 / 1024 / 1024);
var_dump($totalsize);
var_dump($totalsize / 1024 / 1024 / 1024);
var_dump($kalanSize);
var_dump($kalanSize / 1024 / 1024 / 1024);
exit(0);